/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.producer;

import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.producer.ILogCallback;
import com.aliyun.openservices.log.producer.ProducerConfig;
import com.aliyun.openservices.log.producer.ProjectConfig;
import com.aliyun.openservices.log.producer.inner.ClientPool;
import com.aliyun.openservices.log.producer.inner.PackageManager;
import java.util.List;

public class LogProducer {
    private ClientPool clientPool;
    private ProducerConfig producerConfig;
    private PackageManager manager;

    public LogProducer(ProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
        this.clientPool = new ClientPool(producerConfig);
        this.manager = new PackageManager(this.producerConfig, this.clientPool);
    }

    public void setProjectConfig(ProjectConfig config) {
        this.clientPool.updateClient(config);
    }

    public void removeProjectConfig(String project) {
        this.clientPool.removeClient(project);
    }

    public void send(String project, String logStore, String topic, String shardHash, String source, List<LogItem> logItems, ILogCallback callabck) {
        this.manager.add(project, logStore, topic, shardHash, source, logItems, callabck);
    }

    public void send(String project, String logStore, String topic, String shardHash, String source, List<LogItem> logItems) {
        this.manager.add(project, logStore, topic, shardHash, source, logItems, null);
    }

    public void send(String project, String logStore, String topic, String source, List<LogItem> logItems, ILogCallback callabck) {
        this.manager.add(project, logStore, topic, null, source, logItems, callabck);
    }

    public void send(String project, String logStore, String topic, String source, List<LogItem> logItems) {
        this.manager.add(project, logStore, topic, null, source, logItems, null);
    }

    public void flush() {
        this.manager.flush();
    }

    public void close() {
        this.manager.close();
    }

    public void closeNow() {
        this.manager.closeNow();
    }

    public int availablePermits() {
        return this.manager.availablePermits();
    }

    public ProducerConfig getProducerConfig() {
        return this.producerConfig;
    }

    public void setProducerConfig(ProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
    }
}

