/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.producer.sample;

import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.producer.LogProducer;
import com.aliyun.openservices.log.producer.ProducerConfig;
import com.aliyun.openservices.log.producer.ProjectConfig;
import com.aliyun.openservices.log.producer.sample.CallbackSample;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class ProducerSample {
    private static final String MOCK_IP = "192.168.0.25";
    private static final int ThreadsCount = 1;

    private static ProjectConfig buildProjectConfig1() {
        String projectName = System.getenv("project1");
        String endpoint = System.getenv("endpoint1");
        String accessKeyId = System.getenv("accessKeyId");
        String accessKey = System.getenv("accessKey");
        return new ProjectConfig(projectName, endpoint, accessKeyId, accessKey);
    }

    private static ProjectConfig buildProjectConfig2() {
        String projectName = System.getenv("project2");
        String endpoint = System.getenv("endpoint2");
        String accessKeyId = System.getenv("accessKeyId");
        String accessKey = System.getenv("accessKey");
        return new ProjectConfig(projectName, endpoint, accessKeyId, accessKey);
    }

    public static String RandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int num = random.nextInt(62);
            buf.append(str.charAt(num));
        }
        return buf.toString();
    }

    public static void main(String[] args) throws InterruptedException {
        int i;
        System.out.println(System.currentTimeMillis());
        ProducerConfig producerConfig = new ProducerConfig();
        final LogProducer producer = new LogProducer(producerConfig);
        producer.setProjectConfig(ProducerSample.buildProjectConfig1());
        producer.setProjectConfig(ProducerSample.buildProjectConfig2());
        final Vector logGroups = new Vector();
        for (int i2 = 0; i2 < 100000; ++i2) {
            Vector<LogItem> tmpLogGroup = new Vector<LogItem>();
            LogItem logItem = new LogItem((int)(new Date().getTime() / 1000L));
            logItem.PushBack("level", "info " + System.currentTimeMillis());
            logItem.PushBack("message", "mmmmmdekdekjdefjekjfek" + ProducerSample.RandomString(50));
            logItem.PushBack("method", "SenderToServer " + ProducerSample.RandomString(10));
            tmpLogGroup.add(logItem);
            logGroups.add(tmpLogGroup);
        }
        Thread[] threads = new Thread[1];
        for (i = 0; i < 1; ++i) {
            threads[i] = new Thread(null, new Runnable(){
                Random random = new Random();

                @Override
                public void run() {
                    int j = 0;
                    int rand = this.random.nextInt(99999);
                    while (++j < 10) {
                        producer.send(System.getenv("project1"), "store_1s", "topic1", ProducerSample.MOCK_IP, (List)logGroups.get(rand), new CallbackSample(System.getenv("project1"), "store_1s", "topic1", ProducerSample.MOCK_IP, null, (Vector)logGroups.get(rand), producer));
                    }
                }
            }, i + "");
            threads[i].start();
        }
        Thread.sleep(5000L);
        for (i = 0; i < 1; ++i) {
            threads[i].interrupt();
        }
        producer.flush();
        producer.close();
    }
}

