/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.producer.inner;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.Shard;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.producer.ProducerConfig;
import com.aliyun.openservices.log.producer.inner.ClientPool;
import com.aliyun.openservices.log.producer.inner.ShardHash;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ShardHashManager {
    private ClientPool clientPool;
    private HashMap<String, ShardHash> shardHash = new HashMap();
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private ProducerConfig producerConfig;

    public ShardHashManager(ClientPool clientPool, ProducerConfig producerConfig) {
        this.clientPool = clientPool;
        this.producerConfig = producerConfig;
    }

    public void filterExpired() {
        ArrayList<String> removes = new ArrayList<String>();
        this.rwLock.readLock().lock();
        long cur = System.currentTimeMillis();
        for (Map.Entry<String, ShardHash> entry : this.shardHash.entrySet()) {
            entry.getValue().rwLock.readLock().lock();
            if (cur - entry.getValue().updateTime > (long)(this.producerConfig.shardHashUpdateIntervalInMS * 2)) {
                removes.add(entry.getKey());
            }
            entry.getValue().rwLock.readLock().unlock();
        }
        this.rwLock.readLock().unlock();
        if (!removes.isEmpty()) {
            this.rwLock.writeLock().lock();
            for (String key : removes) {
                this.shardHash.remove(key);
            }
            this.rwLock.writeLock().unlock();
        }
    }

    public String getBeginHash(String project, String logstore, String hash) {
        if (hash == null) {
            return hash;
        }
        Client client = this.clientPool.getClient(project);
        if (client == null) {
            return hash;
        }
        String key = project + "|" + logstore;
        this.rwLock.readLock().lock();
        ShardHash h = this.shardHash.get(key);
        if (h == null) {
            this.rwLock.readLock().unlock();
            this.rwLock.writeLock().lock();
            h = this.shardHash.get(key);
            if (h == null) {
                h = new ShardHash();
                this.shardHash.put(key, h);
            }
            h.rwLock.readLock().lock();
            this.rwLock.writeLock().unlock();
        } else {
            h.rwLock.readLock().lock();
            this.rwLock.readLock().unlock();
        }
        long cur = System.currentTimeMillis();
        if (cur - h.updateTime >= (long)this.producerConfig.shardHashUpdateIntervalInMS) {
            h.rwLock.readLock().unlock();
            h.rwLock.writeLock().lock();
            if (cur - h.updateTime >= (long)this.producerConfig.shardHashUpdateIntervalInMS) {
                ArrayList shards = null;
                try {
                    shards = client.ListShard(project, logstore).GetShards();
                }
                catch (LogException logException) {
                    // empty catch block
                }
                if (shards != null) {
                    h.hash = new ArrayList();
                    for (Shard s : shards) {
                        if (s.getStatus().compareToIgnoreCase("readonly") == 0) continue;
                        h.hash.add(s.getInclusiveBeginKey());
                    }
                    Collections.sort(h.hash);
                    h.updateTime = cur;
                }
            }
            h.rwLock.writeLock().unlock();
            h.rwLock.readLock().lock();
        }
        if (h.hash != null && !h.hash.isEmpty()) {
            int low = 0;
            int high = h.hash.size() - 1;
            int mid = 0;
            int action = 0;
            while (low <= high) {
                mid = (low + high) / 2;
                int cmp = h.hash.get(mid).compareTo(hash);
                if (cmp == 0) {
                    action = 0;
                    break;
                }
                if (cmp < 0) {
                    action = 1;
                    low = mid + 1;
                    continue;
                }
                action = -1;
                high = mid - 1;
            }
            if (action == -1 && mid > 0) {
                --mid;
            }
            h.rwLock.readLock().unlock();
            return h.hash.get(mid);
        }
        h.rwLock.readLock().unlock();
        return hash;
    }
}

