/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.producer.inner;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.producer.ProducerConfig;
import com.aliyun.openservices.log.producer.ProjectConfig;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClientPool {
    private HashMap<String, String> projectEndpointMap = new HashMap();
    private HashMap<String, Pair> clientPool = new HashMap();
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private ProducerConfig producerConfig;

    public ClientPool(ProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client updateClient(ProjectConfig config) {
        this.rwLock.writeLock().lock();
        try {
            Client client;
            Pair p;
            String ep = this.projectEndpointMap.get(config.projectName);
            int ref = 0;
            if (ep == null) {
                ref = 1;
                this.projectEndpointMap.put(config.projectName, config.endpoint);
                ep = config.endpoint;
            }
            if ((p = this.clientPool.get(ep)) != null) {
                client = p.client;
                p.ref += ref;
            } else {
                client = this.buildClient(config);
                this.clientPool.put(ep, new Pair(client, ref));
            }
            Client client2 = client;
            return client2;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(String project) {
        this.rwLock.writeLock().lock();
        try {
            String ep = this.projectEndpointMap.get(project);
            if (ep != null) {
                this.projectEndpointMap.remove(project);
                Pair p = this.clientPool.get(ep);
                if (--p.ref == 0) {
                    this.clientPool.remove(ep);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient(String project) {
        this.rwLock.readLock().lock();
        try {
            String ep = this.projectEndpointMap.get(project);
            Client c = null;
            if (ep != null) {
                c = this.clientPool.get((Object)ep).client;
            }
            Client client = c;
            return client;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private Client buildClient(ProjectConfig config) {
        Client client = new Client(config.endpoint, config.accessKeyId, config.accessKey);
        client.setUserAgent(this.producerConfig.userAgent);
        if (config.stsToken != null) {
            client.SetSecurityToken(config.stsToken);
        }
        return client;
    }

    class Pair {
        public Client client;
        public int ref;

        public Pair(Client client, int ref) {
            this.client = client;
            this.ref = ref;
        }
    }
}

