/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.model.RowQueryCriteria;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class OffsetRowQueryCriteria
extends RowQueryCriteria {
    private int offset;
    private int top;
    private boolean isReverse;
    private Map<String, PrimaryKeyValue> pagingKeys = new LinkedHashMap<String, PrimaryKeyValue>();

    public OffsetRowQueryCriteria(String tableName) {
        super(tableName);
    }

    public OffsetRowQueryCriteria(String tableName, String viewName) {
        super(tableName, viewName);
    }

    public Map<String, PrimaryKeyValue> getPagingKeys() {
        return Collections.unmodifiableMap(this.pagingKeys);
    }

    public void addPaginKey(String name, PrimaryKeyValue value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (!OTSUtil.nameValid(name)) {
            throw new IllegalArgumentException();
        }
        if (OTSUtil.isPKInf(value)) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("InfPKNotAllowed"));
        }
        this.pagingKeys.put(name, value);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new ArithmeticException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ValueLessThanZero"));
        }
        this.offset = offset;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        if (top < 0) {
            throw new ArithmeticException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ValueLessThanZero"));
        }
        this.top = top;
    }

    public boolean getIsReverse() {
        return this.isReverse;
    }

    public void setIsReverse(boolean isReverse) {
        this.isReverse = isReverse;
    }
}

