/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.StartTransactionResult;
import com.aliyun.openservices.ots.model.PartitionKeyValue;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class OTSTransactionOperation
extends OTSOperation {
    private static final String ACTION_STARTTRANSACTION = "StartTransaction";
    private static final String ACTION_COMMITTRANSACTION = "CommitTransaction";
    private static final String ACTION_ABORTTRANSACTION = "AbortTransaction";

    public OTSTransactionOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials) {
        super(endpoint, client, credentials);
    }

    public String startTransaction(String entityName, PartitionKeyValue pkValue) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(entityName, " entityName");
        OTSUtil.ensureNameValid(entityName);
        CodingUtils.assertParameterNotNull(pkValue, "pkValue");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("EntityName", entityName);
        params.put("PartitionKeyValue", OTSUtil.getParameterString(pkValue));
        params.put("PartitionKeyType", pkValue.getType().toString());
        StartTransactionResult result = (StartTransactionResult)this.invoke(ACTION_STARTTRANSACTION, HttpMethod.GET, params, StartTransactionResult.class);
        return result.TransactionId;
    }

    public void commitTransaction(String transactionId) throws OTSException, ClientException {
        CodingUtils.assertStringNotNullOrEmpty(transactionId, "transactionId");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TransactionID", transactionId);
        this.invokeNoResult(ACTION_COMMITTRANSACTION, HttpMethod.GET, params);
    }

    public void abortTransaction(String transactionId) throws OTSException, ClientException {
        CodingUtils.assertStringNotNullOrEmpty(transactionId, "transactionId");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TransactionID", transactionId);
        this.invokeNoResult(ACTION_ABORTTRANSACTION, HttpMethod.GET, params);
    }
}

