/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.CommonConfigInputDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public abstract class LocalFileConfigInputDetail
extends CommonConfigInputDetail
implements Serializable {
    private static final long serialVersionUID = -5807698217939352222L;
    protected String logPath = "";
    protected String logType = "";
    protected String filePattern = "";
    protected String timeFormat = "";
    protected String topicFormat = "none";
    protected boolean preserve = true;
    protected Integer preserveDepth = 0;
    protected String fileEncoding = "utf8";
    protected boolean discardUnmatch = true;
    protected Integer maxDepth = 1000;
    protected boolean tailExisted = false;
    protected boolean discardNonUtf8 = false;

    public boolean GetTailExisted() {
        return this.tailExisted;
    }

    public void SetTailExisted(boolean tailExisted) {
        this.tailExisted = tailExisted;
    }

    public boolean GetDiscardNonUtf8() {
        return this.discardNonUtf8;
    }

    public void SetDiscardNonUtf8(boolean discardNonUtf8) {
        this.discardNonUtf8 = discardNonUtf8;
    }

    public String GetLogType() {
        return this.logType;
    }

    public void SetLogType(String logType) {
        this.logType = logType;
    }

    public Integer GetMaxDepth() {
        return this.maxDepth;
    }

    public void SetMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean GetDiscardUnmatch() {
        return this.discardUnmatch;
    }

    public void SetDiscardUnmatch(boolean discardUnmatch) {
        this.discardUnmatch = discardUnmatch;
    }

    public String GetFileEncoding() {
        return this.fileEncoding;
    }

    public void SetFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public boolean GetPreserve() {
        return this.preserve;
    }

    public void SetPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public Integer GetPreserveDepth() {
        return this.preserveDepth;
    }

    public void SetPreserveDepth(Integer preserveDepth) {
        this.preserveDepth = preserveDepth;
    }

    public String GetLogPath() {
        return this.logPath;
    }

    public void SetLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String GetFilePattern() {
        return this.filePattern;
    }

    public void SetFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String GetTimeFormat() {
        return this.timeFormat;
    }

    public void SetTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String GetTopicFormat() {
        return this.topicFormat;
    }

    public void SetTopicFormat(String topicFormat) {
        this.topicFormat = topicFormat;
    }

    protected void LocalFileConfigToJsonObject(JSONObject jsonObj) {
        this.CommonConfigToJsonObject(jsonObj);
        jsonObj.put((Object)"logPath", (Object)this.logPath);
        jsonObj.put((Object)"filePattern", (Object)this.filePattern);
        jsonObj.put((Object)"logType", (Object)this.logType);
        jsonObj.put((Object)"timeFormat", (Object)this.timeFormat);
        jsonObj.put((Object)"fileEncoding", (Object)this.fileEncoding);
        jsonObj.put((Object)"preserve", (Object)this.preserve);
        jsonObj.put((Object)"preserveDepth", (Object)this.preserveDepth);
        jsonObj.put((Object)"topicFormat", (Object)this.topicFormat);
        jsonObj.put((Object)"maxDepth", (Object)this.maxDepth);
        jsonObj.put((Object)"discardNonUtf8", (Object)this.discardNonUtf8);
        jsonObj.put((Object)"tailExisted", (Object)this.tailExisted);
    }

    protected void LocalFileConfigFromJsonObject(JSONObject inputDetail) throws LogException {
        try {
            this.CommonConfigFromJsonObject(inputDetail);
            this.logPath = inputDetail.getString("logPath");
            this.filePattern = inputDetail.getString("filePattern");
            this.logType = inputDetail.getString("logType");
            this.timeFormat = inputDetail.has("timeFormat") ? inputDetail.getString("timeFormat") : "";
            this.fileEncoding = inputDetail.has("fileEncoding") ? inputDetail.getString("fileEncoding") : "utf8";
            this.preserve = inputDetail.has("preserve") ? inputDetail.getBoolean("preserve") : true;
            this.preserveDepth = inputDetail.has("preserveDepth") ? Integer.valueOf(inputDetail.getInt("preserveDepth")) : Integer.valueOf(0);
            this.discardUnmatch = inputDetail.has("discardUnmatch") ? inputDetail.getBoolean("discardUnmatch") : true;
            this.maxDepth = inputDetail.has("maxDepth") ? Integer.valueOf(inputDetail.getInt("maxDepth")) : Integer.valueOf(1000);
            this.topicFormat = inputDetail.has("topicFormat") ? inputDetail.getString("topicFormat") : "none";
            this.discardNonUtf8 = inputDetail.has("discardNonUtf8") ? inputDetail.getBoolean("discardNonUtf8") : false;
            this.tailExisted = inputDetail.has("tailExisted") ? inputDetail.getBoolean("tailExisted") : false;
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }
}

