/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.util;

import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Joiner;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

public class Utils {
    private static Random rand = new Random();

    public static int randInt(int min, int max) {
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    public static String getHTTPParamsAsUrlStr(String method, Map<String, String> params) {
        if (!"GET".equals(method) || params == null || params.size() <= 0) {
            return "";
        }
        LinkedList<String> paramstring = Lists.newLinkedList();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = Utils.percentEncode(entry.getKey());
            String value = Utils.percentEncode(entry.getValue());
            StringBuilder sb = new StringBuilder();
            paramstring.add(sb.append(key).append("=").append(value).toString());
        }
        return "?" + Joiner.on("&").join(paramstring);
    }

    public static String urlEncodeWithUTF8(String value) {
        if (null == value) {
            return null;
        }
        String encode = "UTF-8";
        try {
            return URLEncoder.encode(value, encode);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM DOES NOT SUPPORT " + encode + "?");
        }
    }

    public static String percentEncode(String value) {
        if (null == value) {
            return null;
        }
        return Utils.urlEncodeWithUTF8(value).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    public static String normalize(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append(str.endsWith("/") ? str.substring(0, str.length() - 1) : str);
        return sb.toString();
    }
}

