/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.sdk.dependencies.org.apache.http.client.protocol;

import com.aliyun.opensearch.sdk.dependencies.org.apache.http.HttpException;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.HttpRequest;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.HttpRequestInterceptor;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.annotation.Immutable;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.List;

@Immutable
public class RequestAcceptEncoding
implements HttpRequestInterceptor {
    private final String acceptEncoding;

    public RequestAcceptEncoding(List<String> encodings) {
        if (encodings != null && !encodings.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < encodings.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(encodings.get(i));
            }
            this.acceptEncoding = buf.toString();
        } else {
            this.acceptEncoding = "gzip,deflate";
        }
    }

    public RequestAcceptEncoding() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (!request.containsHeader("Accept-Encoding")) {
            request.addHeader("Accept-Encoding", this.acceptEncoding);
        }
    }
}

