/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.mapred.utils.SchemaUtils$AjcClosure1;
import com.aliyun.odps.mapred.utils.SchemaUtils$AjcClosure3;
import com.aliyun.odps.mapred.utils.SchemaUtils$AjcClosure5;
import com.aliyun.odps.mapred.utils.SchemaUtils$AjcClosure7;
import java.util.ArrayList;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SchemaUtils {
    private static final String SEPERATOR = ",";
    private static final String DELIMITER = ":";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public static Column[] fromString(String str) {
        if (str == null || str.isEmpty()) {
            return new Column[0];
        }
        String remain = str;
        ArrayList<Column> cols = new ArrayList<Column>();
        while (remain.length() > 0) {
            String tok;
            String[] knv;
            int pos = remain.indexOf(SEPERATOR);
            if (pos < 0) {
                pos = remain.length();
            }
            if ((knv = (tok = remain.substring(0, pos)).split(DELIMITER, 2)).length != 2) {
                throw new IllegalArgumentException("Malformed schema definition, expecting \"name:type\" but was \"" + tok + "\"");
            }
            if (knv[1].toUpperCase().startsWith("MAP")) {
                if ((pos = remain.indexOf(SEPERATOR, pos + 1)) < 0) {
                    pos = remain.length();
                }
                tok = remain.substring(0, pos);
                knv = tok.split(DELIMITER, 2);
            }
            remain = pos == remain.length() ? "" : remain.substring(pos + 1);
            cols.add(SchemaUtils.getColumn(knv[0], knv[1]));
        }
        return cols.toArray(new Column[0]);
    }

    public static String toString(Column[] cols) {
        if (cols == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Column c : cols) {
            if (c == null) continue;
            if (sb.length() > 0) {
                sb.append(SEPERATOR);
            }
            sb.append(c.getName()).append(DELIMITER).append(SchemaUtils.getOdpsTypeString(c));
        }
        return sb.toString();
    }

    public static String[] getNames(Column[] cols) {
        String[] names = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            names[i] = cols[i].getName();
        }
        return names;
    }

    public static OdpsType[] getTypes(Column[] cols) {
        OdpsType[] types = new OdpsType[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            Column column = cols[i];
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, (Object)column);
            Object[] objectArray = new Object[]{column, joinPoint};
            types[i] = (OdpsType)OdpsDeprecatedLogger.aspectOf().around(new SchemaUtils$AjcClosure1(objectArray).linkClosureAndJoinPoint(16));
        }
        return types;
    }

    private static String getOdpsTypeString(Column tp) {
        StringBuilder sb = new StringBuilder();
        Column column = tp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, (Object)column);
        Object[] objectArray = new Object[]{column, joinPoint};
        if ((OdpsType)OdpsDeprecatedLogger.aspectOf().around(new SchemaUtils$AjcClosure3(objectArray).linkClosureAndJoinPoint(16)) == OdpsType.ARRAY) {
            sb.append("ARRAY<");
            sb.append(((OdpsType)tp.getGenericTypeList().get(0)).toString());
            sb.append(">");
        } else {
            Column column2 = tp;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, (Object)column2);
            Object[] objectArray2 = new Object[]{column2, joinPoint2};
            if ((OdpsType)OdpsDeprecatedLogger.aspectOf().around(new SchemaUtils$AjcClosure5(objectArray2).linkClosureAndJoinPoint(16)) == OdpsType.MAP) {
                sb.append("MAP<");
                sb.append(((OdpsType)tp.getGenericTypeList().get(0)).toString());
                sb.append(SEPERATOR);
                sb.append(((OdpsType)tp.getGenericTypeList().get(1)).toString());
                sb.append(">");
            } else {
                Column column3 = tp;
                JoinPoint joinPoint3 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, (Object)column3);
                Object[] objectArray3 = new Object[]{column3, joinPoint3};
                sb.append(((OdpsType)OdpsDeprecatedLogger.aspectOf().around(new SchemaUtils$AjcClosure7(objectArray3).linkClosureAndJoinPoint(16))).toString());
            }
        }
        return sb.toString();
    }

    private static Column getColumn(String name, String typeStr) {
        name = name.trim();
        if ((typeStr = typeStr.toUpperCase().trim()).startsWith("ARRAY<")) {
            String remain = typeStr.substring(6);
            if (remain.length() < 2 || remain.charAt(remain.length() - 1) != '>') {
                throw new IllegalArgumentException("Malformed schema, not a valid array type: " + typeStr);
            }
            OdpsType elementType = OdpsType.valueOf((String)remain.substring(0, remain.length() - 1));
            Column col = new Column(name, OdpsType.ARRAY);
            col.setGenericTypeList(Arrays.asList(elementType));
            return col;
        }
        if (typeStr.startsWith("MAP<")) {
            String remain = typeStr.substring(4);
            if (remain.length() < 4 || remain.charAt(remain.length() - 1) != '>') {
                throw new IllegalArgumentException("Malformed schema, not a valid map type: " + typeStr);
            }
            String[] knv = (remain = remain.substring(0, remain.length() - 1)).split(SEPERATOR, 2);
            if (knv.length != 2) {
                throw new IllegalArgumentException("Malformed schema , not a valid map type: " + typeStr);
            }
            Column col = new Column(name, OdpsType.MAP);
            col.setGenericTypeList(Arrays.asList(OdpsType.valueOf((String)knv[0]), OdpsType.valueOf((String)knv[1])));
            return col;
        }
        return new Column(name, OdpsType.valueOf((String)typeStr));
    }

    static {
        SchemaUtils.ajc$preClinit();
    }

    static /* synthetic */ OdpsType getType_aroundBody0(Column column, JoinPoint joinPoint) {
        return column.getType();
    }

    static /* synthetic */ OdpsType getType_aroundBody2(Column column, JoinPoint joinPoint) {
        return column.getType();
    }

    static /* synthetic */ OdpsType getType_aroundBody4(Column column, JoinPoint joinPoint) {
        return column.getType();
    }

    static /* synthetic */ OdpsType getType_aroundBody6(Column column, JoinPoint joinPoint) {
        return column.getType();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SchemaUtils.java", SchemaUtils.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getType", "com.aliyun.odps.Column", "", "", "", "com.aliyun.odps.OdpsType"), 134);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getType", "com.aliyun.odps.Column", "", "", "", "com.aliyun.odps.OdpsType"), 141);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getType", "com.aliyun.odps.Column", "", "", "", "com.aliyun.odps.OdpsType"), 145);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getType", "com.aliyun.odps.Column", "", "", "", "com.aliyun.odps.OdpsType"), 152);
    }
}

