/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.utils;

import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.mapred.conf.JobConf;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;

public class InputUtils {
    private static final Gson gson = new GsonBuilder().create();
    private static final String INPUT_DESC = "odps.mapred.input.desc";
    private static final String VOLUME_INPUT_DESC = "odps.mapred.volume.input.desc";

    public static void addTable(TableInfo table, JobConf conf) {
        TableInfo[] tableInfos = InputUtils.getTables(conf);
        tableInfos = tableInfos == null ? new TableInfo[1] : Arrays.copyOf(tableInfos, tableInfos.length + 1);
        tableInfos[tableInfos.length - 1] = table;
        conf.set(INPUT_DESC, gson.toJson((Object)tableInfos));
        if (table.getMapperClass() != null && conf.get("odps.mapred.map.class") == null) {
            conf.setMapperClass(table.getMapperClass());
        }
    }

    public static void setTables(TableInfo[] tables, JobConf conf) {
        if (tables != null && tables.length > 0) {
            conf.set(INPUT_DESC, gson.toJson((Object)tables));
        } else {
            conf.set(INPUT_DESC, "");
        }
    }

    public static TableInfo[] getTables(JobConf conf) {
        String inputDesc = conf.get(INPUT_DESC);
        if (inputDesc != null && !inputDesc.isEmpty()) {
            return (TableInfo[])gson.fromJson(inputDesc, TableInfo[].class);
        }
        return null;
    }

    public static void addVolume(VolumeInfo volume, JobConf conf) {
        VolumeInfo[] volumeInfos = InputUtils.getVolumes(conf);
        volumeInfos = volumeInfos == null ? new VolumeInfo[1] : Arrays.copyOf(volumeInfos, volumeInfos.length + 1);
        volumeInfos[volumeInfos.length - 1] = volume;
        conf.set(VOLUME_INPUT_DESC, gson.toJson((Object)volumeInfos));
    }

    public static void setVolumes(VolumeInfo[] volumes, JobConf conf) {
        if (volumes != null && volumes.length > 0) {
            conf.set(VOLUME_INPUT_DESC, gson.toJson((Object)volumes));
        } else {
            conf.set(VOLUME_INPUT_DESC, "");
        }
    }

    public static VolumeInfo[] getVolumes(JobConf conf) {
        String volumeInputDesc = conf.get(VOLUME_INPUT_DESC);
        if (volumeInputDesc != null && !volumeInputDesc.isEmpty()) {
            return (VolumeInfo[])gson.fromJson(volumeInputDesc, VolumeInfo[].class);
        }
        return null;
    }
}

