/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.example;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import java.io.IOException;
import java.util.Iterator;

public class Identity {
    public static void main(String[] args) throws OdpsException {
        if (args.length != 2) {
            System.err.println("Usage: Identity <in_table> <out_table>");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(IdentityMapper.class);
        job.setReducerClass(IdentityReducer.class);
        job.setMapOutputKeySchema(new Column[]{new Column("word", OdpsType.STRING)});
        job.setMapOutputValueSchema(new Column[]{new Column("count", OdpsType.BIGINT)});
        InputUtils.addTable(TableInfo.builder().tableName(args[0]).build(), job);
        OutputUtils.addTable(TableInfo.builder().tableName(args[1]).build(), job);
        JobClient.runJob(job);
    }

    public static class IdentityReducer
    extends ReducerBase {
        @Override
        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            context.write(key);
        }
    }

    public static class IdentityMapper
    extends MapperBase {
        Record v;

        @Override
        public void setup(Mapper.TaskContext context) throws IOException {
            this.v = context.createMapOutputValueRecord();
        }

        @Override
        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            context.write(record, this.v);
        }
    }
}

