/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.io.DatetimeWritable;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Writable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CommonUtils {
    private static final String[] ONE_STRING_ARRAY;
    private static final String TIMESTAMP_FORMAT_S = "yyyyMMddHHmmss_SSS";
    @Deprecated
    public static final SimpleDateFormat TIMESTAMP_FORMAT;
    private static final NullWritable nullWritable;
    private static final String DATETIME_FORMAT_S = "yyyy-MM-dd HH:mm:ss";
    @Deprecated
    public static final SimpleDateFormat DATETIME_FORMAT;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public static SimpleDateFormat getTimestampFormat() {
        return new SimpleDateFormat(TIMESTAMP_FORMAT_S);
    }

    public static SimpleDateFormat getDatetimeFormat() {
        return new SimpleDateFormat(DATETIME_FORMAT_S);
    }

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public static String generateMrTaskName() {
        return "console_mr_" + CommonUtils.getTimestampFormat().format(new Date());
    }

    public static String generateLocalMrTaskName() {
        return "mr_" + CommonUtils.getTimestampFormat().format(new Date()) + "_" + CommonUtils.getPID();
    }

    public static String generateGraphTaskName() {
        return "console_graph_" + CommonUtils.getTimestampFormat().format(new Date());
    }

    public static String generateLocalGraphTaskName() {
        return "graph_" + CommonUtils.getTimestampFormat().format(new Date()) + "_" + CommonUtils.getPID();
    }

    public static String getCurrentTime() {
        return CommonUtils.getDatetimeFormat().format(new Date());
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String toDelimitedString(Writable[] fields, char delim, String nullIndicator) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            Writable field;
            if (i != 0) {
                buf.append(delim);
            }
            if ((field = fields[i]) == null || field == nullWritable) {
                buf.append(nullIndicator);
                continue;
            }
            buf.append(field.toString());
        }
        return buf.toString();
    }

    private static Writable parseDateTime(String val) throws IOException {
        try {
            return new DatetimeWritable(Long.parseLong(val));
        }
        catch (NumberFormatException e) {
            try {
                return new DatetimeWritable(CommonUtils.getDatetimeFormat().parse(val).getTime());
            }
            catch (ParseException ex) {
                throw new IOException("unsupported date time format:" + val);
            }
        }
    }

    public static LinkedHashMap<String, String> convertPartSpecToMap(String partSpec) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (partSpec != null && !partSpec.trim().isEmpty()) {
            String[] parts;
            for (String part : parts = partSpec.split("/")) {
                String[] ss = part.split("=");
                if (ss.length != 2) {
                    throw new RuntimeException("ODPS-0730001: error part spec format: " + partSpec);
                }
                map.put(ss[0], ss[1]);
            }
        }
        return map;
    }

    public static String convertPartSpecMapToString(LinkedHashMap<String, String> partSpecMap) {
        String partSpec = "";
        if (partSpecMap != null) {
            for (Map.Entry<String, String> entry : partSpecMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) {
                    throw new RuntimeException("ODPS-0730001: partition name or value can't be null: " + entry.getKey() + "=" + entry.getValue());
                }
                String part = entry.getKey().trim() + "=" + entry.getValue().trim();
                partSpec = partSpec + (partSpec.isEmpty() ? part : "/" + part);
            }
        }
        return partSpec;
    }

    public static void checkArgument(String name, int value, int lower_bound, int upper_bound) {
        if (value < lower_bound || value > upper_bound) {
            throw new RuntimeException("Local Run: Value of " + name + " out of bound, must be in range [" + lower_bound + "," + upper_bound + "].");
        }
    }

    static {
        CommonUtils.ajc$preClinit();
        ONE_STRING_ARRAY = new String[]{""};
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT_S);
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)simpleDateFormat);
        CommonUtils.TIMESTAMP_FORMAT_aroundBody1$advice(simpleDateFormat, joinPoint, OdpsDeprecatedLogger.aspectOf(), (ProceedingJoinPoint)joinPoint);
        nullWritable = NullWritable.get();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(DATETIME_FORMAT_S);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)simpleDateFormat2);
        CommonUtils.DATETIME_FORMAT_aroundBody3$advice(simpleDateFormat2, joinPoint2, OdpsDeprecatedLogger.aspectOf(), (ProceedingJoinPoint)joinPoint2);
    }

    private static /* synthetic */ Object TIMESTAMP_FORMAT_aroundBody1$advice(SimpleDateFormat TIMESTAMP_FORMAT, JoinPoint thisJoinPoint, OdpsDeprecatedLogger ajc$aspectInstance, ProceedingJoinPoint point) {
        try {
            String methodSignature = point.getSignature().toString();
            Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
            calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
            OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
        }
        catch (Throwable e) {
            // empty catch block
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        CommonUtils.TIMESTAMP_FORMAT = TIMESTAMP_FORMAT;
        return null;
    }

    private static /* synthetic */ Object DATETIME_FORMAT_aroundBody3$advice(SimpleDateFormat DATETIME_FORMAT, JoinPoint thisJoinPoint, OdpsDeprecatedLogger ajc$aspectInstance, ProceedingJoinPoint point) {
        try {
            String methodSignature = point.getSignature().toString();
            Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
            calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
            OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
        }
        catch (Throwable e) {
            // empty catch block
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        CommonUtils.DATETIME_FORMAT = DATETIME_FORMAT;
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CommonUtils.java", CommonUtils.class);
        ajc$tjp_0 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("19", "TIMESTAMP_FORMAT", "com.aliyun.odps.utils.CommonUtils", "java.text.SimpleDateFormat"), 51);
        ajc$tjp_1 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("19", "DATETIME_FORMAT", "com.aliyun.odps.utils.CommonUtils", "java.text.SimpleDateFormat"), 68);
    }
}

