/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
abstract class BufferedDataBlockEncoder
implements DataBlockEncoder {
    private static int INITIAL_KEY_BUFFER_SIZE = 512;

    BufferedDataBlockEncoder() {
    }

    @Override
    public ByteBuffer decodeKeyValues(DataInputStream source, HFileBlockDecodingContext blkDecodingCtx) throws IOException {
        if (blkDecodingCtx.getClass() != HFileBlockDefaultDecodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultDecodingContext.class.getName() + " as the decoding context.");
        }
        HFileBlockDefaultDecodingContext decodingCtx = (HFileBlockDefaultDecodingContext)blkDecodingCtx;
        if (decodingCtx.getHFileContext().isIncludesTags() && decodingCtx.getHFileContext().isCompressTags()) {
            if (decodingCtx.getTagCompressionContext() != null) {
                decodingCtx.getTagCompressionContext().clear();
            } else {
                try {
                    TagCompressionContext tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                    decodingCtx.setTagCompressionContext(tagCompressionContext);
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize TagCompressionContext", e);
                }
            }
        }
        return this.internalDecodeKeyValues(source, 0, 0, decodingCtx);
    }

    protected final int afterEncodingKeyValue(Cell cell, DataOutputStream out, HFileBlockDefaultEncodingContext encodingCtx) throws IOException {
        int size = 0;
        if (encodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = cell.getTagsLength();
            ByteBufferUtils.putCompressedInt(out, tagsLength);
            if (tagsLength > 0) {
                TagCompressionContext tagCompressionContext = encodingCtx.getTagCompressionContext();
                if (tagCompressionContext != null) {
                    tagCompressionContext.compressTags(out, cell.getTagsArray(), cell.getTagsOffset(), tagsLength);
                } else {
                    out.write(cell.getTagsArray(), cell.getTagsOffset(), tagsLength);
                }
            }
            size += tagsLength + 2;
        }
        if (encodingCtx.getHFileContext().isIncludesMvcc()) {
            long memstoreTS = cell.getSequenceId();
            WritableUtils.writeVLong((DataOutput)out, (long)memstoreTS);
            size += WritableUtils.getVIntSize((long)memstoreTS);
        }
        return size;
    }

    protected final void afterDecodingKeyValue(DataInputStream source, ByteBuffer dest, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        if (decodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = ByteBufferUtils.readCompressedInt(source);
            dest.put((byte)(tagsLength >> 8 & 0xFF));
            dest.put((byte)(tagsLength & 0xFF));
            if (tagsLength > 0) {
                TagCompressionContext tagCompressionContext = decodingCtx.getTagCompressionContext();
                if (tagCompressionContext != null) {
                    tagCompressionContext.uncompressTags(source, dest, tagsLength);
                } else {
                    ByteBufferUtils.copyFromStreamToBuffer(dest, source, tagsLength);
                }
            }
        }
        if (decodingCtx.getHFileContext().isIncludesMvcc()) {
            long memstoreTS = -1L;
            try {
                memstoreTS = WritableUtils.readVLong((DataInput)source);
                ByteBufferUtils.writeVLong(dest, memstoreTS);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to copy memstore timestamp " + memstoreTS + " after decoding a key/value");
            }
        }
    }

    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(DataBlockEncoding encoding, byte[] header, HFileContext meta) {
        return new HFileBlockDefaultEncodingContext(encoding, header, meta);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(meta);
    }

    protected abstract ByteBuffer internalDecodeKeyValues(DataInputStream var1, int var2, int var3, HFileBlockDefaultDecodingContext var4) throws IOException;

    protected static void ensureSpace(ByteBuffer out, int length) throws EncoderBufferTooSmallException {
        if (out.position() + length > out.limit()) {
            throw new EncoderBufferTooSmallException("Buffer position=" + out.position() + ", buffer limit=" + out.limit() + ", length to be written=" + length);
        }
    }

    @Override
    public void startBlockEncoding(HFileBlockEncodingContext blkEncodingCtx, DataOutputStream out) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding(out);
        if (encodingCtx.getHFileContext().isIncludesTags() && encodingCtx.getHFileContext().isCompressTags()) {
            if (encodingCtx.getTagCompressionContext() != null) {
                encodingCtx.getTagCompressionContext().clear();
            } else {
                try {
                    TagCompressionContext tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                    encodingCtx.setTagCompressionContext(tagCompressionContext);
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize TagCompressionContext", e);
                }
            }
        }
        ByteBufferUtils.putInt(out, 0);
        blkEncodingCtx.setEncodingState(new BufferedDataBlockEncodingState());
    }

    @Override
    public int encode(Cell cell, HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        BufferedDataBlockEncodingState state = (BufferedDataBlockEncodingState)encodingCtx.getEncodingState();
        int encodedKvSize = this.internalEncode(cell, (HFileBlockDefaultEncodingContext)encodingCtx, out);
        state.unencodedDataSizeWritten += encodedKvSize;
        return encodedKvSize;
    }

    public abstract int internalEncode(Cell var1, HFileBlockDefaultEncodingContext var2, DataOutputStream var3) throws IOException;

    @Override
    public void endBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out, byte[] uncompressedBytesWithHeader) throws IOException {
        BufferedDataBlockEncodingState state = (BufferedDataBlockEncodingState)encodingCtx.getEncodingState();
        Bytes.putInt(uncompressedBytesWithHeader, 35, state.unencodedDataSizeWritten);
        if (encodingCtx.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            encodingCtx.postEncoding(BlockType.ENCODED_DATA);
        } else {
            encodingCtx.postEncoding(BlockType.DATA);
        }
    }

    static /* synthetic */ int access$000() {
        return INITIAL_KEY_BUFFER_SIZE;
    }

    private static class BufferedDataBlockEncodingState
    extends EncodingState {
        int unencodedDataSizeWritten = 0;

        private BufferedDataBlockEncodingState() {
        }
    }

    protected static abstract class BufferedEncodedSeeker<STATE extends SeekerState>
    implements DataBlockEncoder.EncodedSeeker {
        protected HFileBlockDecodingContext decodingCtx;
        protected final KeyValue.KVComparator comparator;
        protected final KeyValue.SamePrefixComparator<byte[]> samePrefixComparator;
        protected ByteBuffer currentBuffer;
        protected STATE current = this.createSeekerState();
        protected STATE previous = this.createSeekerState();
        protected TagCompressionContext tagCompressionContext = null;

        public BufferedEncodedSeeker(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
            this.comparator = comparator;
            this.samePrefixComparator = comparator;
            this.decodingCtx = decodingCtx;
            if (decodingCtx.getHFileContext().isCompressTags()) {
                try {
                    this.tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize TagCompressionContext", e);
                }
            }
        }

        protected boolean includesMvcc() {
            return this.decodingCtx.getHFileContext().isIncludesMvcc();
        }

        protected boolean includesTags() {
            return this.decodingCtx.getHFileContext().isIncludesTags();
        }

        @Override
        public int compareKey(KeyValue.KVComparator comparator, byte[] key, int offset, int length) {
            return comparator.compareFlatKey(key, offset, length, ((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
        }

        @Override
        public int compareKey(KeyValue.KVComparator comparator, Cell key) {
            return comparator.compareOnlyKeyPortion(key, new KeyValue.KeyOnlyKeyValue(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength));
        }

        @Override
        public void setCurrentBuffer(ByteBuffer buffer) {
            if (this.tagCompressionContext != null) {
                this.tagCompressionContext.clear();
            }
            ((SeekerState)this.current).currentBuffer = this.currentBuffer = buffer;
            if (this.tagCompressionContext != null) {
                ((SeekerState)this.current).tagCompressionContext = this.tagCompressionContext;
            }
            this.decodeFirst();
            ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            ((SeekerState)this.previous).invalidate();
        }

        @Override
        public ByteBuffer getKeyDeepCopy() {
            ByteBuffer keyBuffer = ByteBuffer.allocate(((SeekerState)this.current).keyLength);
            keyBuffer.put(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
            keyBuffer.rewind();
            return keyBuffer;
        }

        @Override
        public ByteBuffer getValueShallowCopy() {
            ByteBuffer dup = this.currentBuffer.duplicate();
            dup.position(((SeekerState)this.current).valueOffset);
            dup.limit(((SeekerState)this.current).valueOffset + ((SeekerState)this.current).valueLength);
            return dup.slice();
        }

        @Override
        public Cell getKeyValue() {
            return ((SeekerState)this.current).shallowCopy();
        }

        @Override
        public void rewind() {
            this.currentBuffer.rewind();
            if (this.tagCompressionContext != null) {
                this.tagCompressionContext.clear();
            }
            this.decodeFirst();
            ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            ((SeekerState)this.previous).invalidate();
        }

        @Override
        public boolean next() {
            if (!this.currentBuffer.hasRemaining()) {
                return false;
            }
            this.decodeNext();
            ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            ((SeekerState)this.previous).invalidate();
            return true;
        }

        protected void decodeTags() {
            ((SeekerState)this.current).tagsLength = ByteBufferUtils.readCompressedInt(this.currentBuffer);
            if (this.tagCompressionContext != null) {
                if (((SeekerState)this.current).uncompressTags) {
                    ((SeekerState)this.current).ensureSpaceForTags();
                    try {
                        ((SeekerState)this.current).tagsCompressedLength = this.tagCompressionContext.uncompressTags(this.currentBuffer, ((SeekerState)this.current).tagsBuffer, 0, ((SeekerState)this.current).tagsLength);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception while uncompressing tags", e);
                    }
                } else {
                    ByteBufferUtils.skip(this.currentBuffer, ((SeekerState)this.current).tagsCompressedLength);
                    ((SeekerState)this.current).uncompressTags = true;
                }
                ((SeekerState)this.current).tagsOffset = -1;
            } else {
                ((SeekerState)this.current).tagsOffset = this.currentBuffer.position();
                ByteBufferUtils.skip(this.currentBuffer, ((SeekerState)this.current).tagsLength);
            }
        }

        @Override
        public int seekToKeyInBlock(byte[] key, int offset, int length, boolean seekBefore) {
            return this.seekToKeyInBlock(new KeyValue.KeyOnlyKeyValue(key, offset, length), seekBefore);
        }

        @Override
        public int seekToKeyInBlock(Cell seekCell, boolean seekBefore) {
            int rowCommonPrefix = 0;
            int familyCommonPrefix = 0;
            int qualCommonPrefix = 0;
            ((SeekerState)this.previous).invalidate();
            KeyValue.KeyOnlyKeyValue currentCell = new KeyValue.KeyOnlyKeyValue();
            while (true) {
                int comp;
                if (this.samePrefixComparator != null) {
                    currentCell.setKey(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
                    if (((SeekerState)this.current).lastCommonPrefix != 0) {
                        rowCommonPrefix = Math.min(rowCommonPrefix, ((SeekerState)this.current).lastCommonPrefix - 2);
                    }
                    if (((SeekerState)this.current).lastCommonPrefix <= 2) {
                        rowCommonPrefix = 0;
                    }
                    if ((comp = CellComparator.compareCommonRowPrefix(seekCell, currentCell, rowCommonPrefix += CellComparator.findCommonPrefixInRowPart(seekCell, currentCell, rowCommonPrefix))) == 0 && (comp = this.compareTypeBytes(seekCell, currentCell)) == 0) {
                        familyCommonPrefix = Math.max(0, Math.min(familyCommonPrefix, ((SeekerState)this.current).lastCommonPrefix - (3 + currentCell.getRowLength())));
                        if ((comp = CellComparator.compareCommonFamilyPrefix(seekCell, currentCell, familyCommonPrefix += CellComparator.findCommonPrefixInFamilyPart(seekCell, currentCell, familyCommonPrefix))) == 0) {
                            qualCommonPrefix = Math.max(0, Math.min(qualCommonPrefix, ((SeekerState)this.current).lastCommonPrefix - (3 + currentCell.getRowLength() + currentCell.getFamilyLength())));
                            if ((comp = CellComparator.compareCommonQualifierPrefix(seekCell, currentCell, qualCommonPrefix += CellComparator.findCommonPrefixInQualifierPart(seekCell, currentCell, qualCommonPrefix))) == 0 && (comp = CellComparator.compareTimestamps(seekCell, currentCell)) == 0) {
                                comp = (0xFF & currentCell.getTypeByte()) - (0xFF & seekCell.getTypeByte());
                            }
                        }
                    }
                } else {
                    KeyValue.KeyOnlyKeyValue r = new KeyValue.KeyOnlyKeyValue(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
                    comp = this.comparator.compareOnlyKeyPortion(seekCell, r);
                }
                if (comp == 0) {
                    if (seekBefore) {
                        if (!((SeekerState)this.previous).isValid()) {
                            throw new IllegalStateException("Cannot seekBefore if positioned at the first key in the block: key=" + Bytes.toStringBinary(seekCell.getRowArray()));
                        }
                        this.moveToPrevious();
                        return 1;
                    }
                    return 0;
                }
                if (comp < 0) {
                    if (!((SeekerState)this.previous).isValid()) {
                        return -2;
                    }
                    this.moveToPrevious();
                    return 1;
                }
                if (!this.currentBuffer.hasRemaining()) break;
                ((SeekerState)this.previous).copyFromNext((SeekerState)this.current);
                this.decodeNext();
                ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            }
            return 1;
        }

        private int compareTypeBytes(Cell key, Cell right) {
            if (key.getFamilyLength() + key.getQualifierLength() == 0 && key.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
                return 1;
            }
            if (right.getFamilyLength() + right.getQualifierLength() == 0 && right.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
                return -1;
            }
            return 0;
        }

        private void moveToPrevious() {
            if (!((SeekerState)this.previous).isValid()) {
                throw new IllegalStateException("Can move back only once and not in first key in the block.");
            }
            STATE tmp = this.previous;
            this.previous = this.current;
            this.current = tmp;
            this.currentBuffer.position(((SeekerState)this.current).nextKvOffset);
            ((SeekerState)this.current).tagsBuffer = ((SeekerState)this.previous).tagsBuffer;
            ((SeekerState)this.current).tagsCompressedLength = ((SeekerState)this.previous).tagsCompressedLength;
            ((SeekerState)this.current).uncompressTags = false;
            ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            ((SeekerState)this.previous).invalidate();
        }

        protected STATE createSeekerState() {
            return (STATE)new SeekerState();
        }

        protected abstract void decodeFirst();

        protected abstract void decodeNext();
    }

    protected static class ClonedSeekerState
    implements Cell,
    HeapSize,
    SettableSequenceId {
        private static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 4 * ClassSize.REFERENCE + 16 + 28 + 2 + 2 + 2 * ClassSize.ARRAY);
        private byte[] keyOnlyBuffer;
        private ByteBuffer currentBuffer;
        private short rowLength;
        private int familyOffset;
        private byte familyLength;
        private int qualifierOffset;
        private int qualifierLength;
        private long timestamp;
        private byte typeByte;
        private int valueOffset;
        private int valueLength;
        private int tagsLength;
        private int tagsOffset;
        private byte[] cloneTagsBuffer;
        private long seqId;
        private TagCompressionContext tagCompressionContext;

        protected ClonedSeekerState(ByteBuffer currentBuffer, byte[] keyBuffer, short rowLength, int familyOffset, byte familyLength, int keyLength, int qualOffset, int qualLength, long timeStamp, byte typeByte, int valueLen, int valueOffset, long seqId, int tagsOffset, int tagsLength, TagCompressionContext tagCompressionContext, byte[] tagsBuffer) {
            this.currentBuffer = currentBuffer;
            this.keyOnlyBuffer = new byte[keyLength];
            this.tagCompressionContext = tagCompressionContext;
            this.rowLength = rowLength;
            this.familyOffset = familyOffset;
            this.familyLength = familyLength;
            this.qualifierOffset = qualOffset;
            this.qualifierLength = qualLength;
            this.timestamp = timeStamp;
            this.typeByte = typeByte;
            this.valueLength = valueLen;
            this.valueOffset = valueOffset;
            this.tagsOffset = tagsOffset;
            this.tagsLength = tagsLength;
            System.arraycopy(keyBuffer, 0, this.keyOnlyBuffer, 0, keyLength);
            if (tagCompressionContext != null) {
                this.cloneTagsBuffer = new byte[tagsLength];
                System.arraycopy(tagsBuffer, 0, this.cloneTagsBuffer, 0, tagsLength);
            }
            this.setSequenceId(seqId);
        }

        @Override
        public byte[] getRowArray() {
            return this.keyOnlyBuffer;
        }

        @Override
        public byte[] getFamilyArray() {
            return this.keyOnlyBuffer;
        }

        @Override
        public byte[] getQualifierArray() {
            return this.keyOnlyBuffer;
        }

        @Override
        public int getRowOffset() {
            return 2;
        }

        @Override
        public short getRowLength() {
            return this.rowLength;
        }

        @Override
        public int getFamilyOffset() {
            return this.familyOffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.familyLength;
        }

        @Override
        public int getQualifierOffset() {
            return this.qualifierOffset;
        }

        @Override
        public int getQualifierLength() {
            return this.qualifierLength;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public byte getTypeByte() {
            return this.typeByte;
        }

        @Override
        @Deprecated
        public long getMvccVersion() {
            return this.getSequenceId();
        }

        @Override
        public long getSequenceId() {
            return this.seqId;
        }

        @Override
        public byte[] getValueArray() {
            return this.currentBuffer.array();
        }

        @Override
        public int getValueOffset() {
            return this.currentBuffer.arrayOffset() + this.valueOffset;
        }

        @Override
        public int getValueLength() {
            return this.valueLength;
        }

        @Override
        public byte[] getTagsArray() {
            if (this.tagCompressionContext != null) {
                return this.cloneTagsBuffer;
            }
            return this.currentBuffer.array();
        }

        @Override
        public int getTagsOffset() {
            if (this.tagCompressionContext != null) {
                return 0;
            }
            return this.currentBuffer.arrayOffset() + this.tagsOffset;
        }

        @Override
        public int getTagsLength() {
            return this.tagsLength;
        }

        @Override
        @Deprecated
        public byte[] getValue() {
            return CellUtil.cloneValue(this);
        }

        @Override
        @Deprecated
        public byte[] getFamily() {
            return CellUtil.cloneFamily(this);
        }

        @Override
        @Deprecated
        public byte[] getQualifier() {
            return CellUtil.cloneQualifier(this);
        }

        @Override
        @Deprecated
        public byte[] getRow() {
            return CellUtil.cloneRow(this);
        }

        public String toString() {
            return KeyValue.keyToString(this.keyOnlyBuffer, 0, KeyValueUtil.keyLength(this)) + "/vlen=" + this.getValueLength() + "/seqid=" + this.seqId;
        }

        @Override
        public void setSequenceId(long seqId) {
            this.seqId = seqId;
        }

        @Override
        public long heapSize() {
            return FIXED_OVERHEAD + (long)this.rowLength + (long)this.familyLength + (long)this.qualifierLength + (long)this.valueLength + (long)this.tagsLength;
        }
    }

    protected static class SeekerState
    implements Cell {
        protected ByteBuffer currentBuffer;
        protected TagCompressionContext tagCompressionContext;
        protected int valueOffset = -1;
        protected int keyLength;
        protected int valueLength;
        protected int lastCommonPrefix;
        protected int tagsLength = 0;
        protected int tagsOffset = -1;
        protected int tagsCompressedLength = 0;
        protected boolean uncompressTags = true;
        protected byte[] keyBuffer = new byte[BufferedDataBlockEncoder.access$000()];
        protected byte[] tagsBuffer = new byte[BufferedDataBlockEncoder.access$000()];
        protected long memstoreTS;
        protected int nextKvOffset;
        protected KeyValue.KeyOnlyKeyValue currentKey = new KeyValue.KeyOnlyKeyValue();

        protected SeekerState() {
        }

        protected boolean isValid() {
            return this.valueOffset != -1;
        }

        protected void invalidate() {
            this.valueOffset = -1;
            this.tagsCompressedLength = 0;
            this.currentKey = new KeyValue.KeyOnlyKeyValue();
            this.uncompressTags = true;
            this.currentBuffer = null;
        }

        protected void ensureSpaceForKey() {
            if (this.keyLength > this.keyBuffer.length) {
                int newKeyBufferLength;
                for (newKeyBufferLength = Math.max(this.keyBuffer.length, 1) * 2; this.keyLength > newKeyBufferLength; newKeyBufferLength *= 2) {
                }
                byte[] newKeyBuffer = new byte[newKeyBufferLength];
                System.arraycopy(this.keyBuffer, 0, newKeyBuffer, 0, this.keyBuffer.length);
                this.keyBuffer = newKeyBuffer;
            }
        }

        protected void ensureSpaceForTags() {
            if (this.tagsLength > this.tagsBuffer.length) {
                int newTagsBufferLength;
                for (newTagsBufferLength = Math.max(this.tagsBuffer.length, 1) * 2; this.tagsLength > newTagsBufferLength; newTagsBufferLength *= 2) {
                }
                byte[] newTagsBuffer = new byte[newTagsBufferLength];
                System.arraycopy(this.tagsBuffer, 0, newTagsBuffer, 0, this.tagsBuffer.length);
                this.tagsBuffer = newTagsBuffer;
            }
        }

        protected void setKey(byte[] keyBuffer, long memTS) {
            this.currentKey.setKey(keyBuffer, 0, this.keyLength);
            this.memstoreTS = memTS;
        }

        protected void copyFromNext(SeekerState nextState) {
            if (this.keyBuffer.length != nextState.keyBuffer.length) {
                this.keyBuffer = (byte[])nextState.keyBuffer.clone();
            } else if (!this.isValid()) {
                System.arraycopy(nextState.keyBuffer, 0, this.keyBuffer, 0, nextState.keyLength);
            } else {
                System.arraycopy(nextState.keyBuffer, nextState.lastCommonPrefix, this.keyBuffer, nextState.lastCommonPrefix, nextState.keyLength - nextState.lastCommonPrefix);
            }
            this.currentKey = nextState.currentKey;
            this.valueOffset = nextState.valueOffset;
            this.keyLength = nextState.keyLength;
            this.valueLength = nextState.valueLength;
            this.lastCommonPrefix = nextState.lastCommonPrefix;
            this.nextKvOffset = nextState.nextKvOffset;
            this.memstoreTS = nextState.memstoreTS;
            this.currentBuffer = nextState.currentBuffer;
            this.tagsOffset = nextState.tagsOffset;
            this.tagsLength = nextState.tagsLength;
            if (nextState.tagCompressionContext != null) {
                this.tagCompressionContext = nextState.tagCompressionContext;
            }
        }

        @Override
        public byte[] getRowArray() {
            return this.currentKey.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return 2;
        }

        @Override
        public short getRowLength() {
            return this.currentKey.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.currentKey.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.currentKey.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.currentKey.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.currentKey.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.currentKey.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.currentKey.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.currentKey.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.currentKey.getTypeByte();
        }

        @Override
        public long getMvccVersion() {
            return this.memstoreTS;
        }

        @Override
        public long getSequenceId() {
            return this.memstoreTS;
        }

        @Override
        public byte[] getValueArray() {
            return this.currentBuffer.array();
        }

        @Override
        public int getValueOffset() {
            return this.currentBuffer.arrayOffset() + this.valueOffset;
        }

        @Override
        public int getValueLength() {
            return this.valueLength;
        }

        @Override
        public byte[] getTagsArray() {
            if (this.tagCompressionContext != null) {
                return this.tagsBuffer;
            }
            return this.currentBuffer.array();
        }

        @Override
        public int getTagsOffset() {
            if (this.tagCompressionContext != null) {
                return 0;
            }
            return this.currentBuffer.arrayOffset() + this.tagsOffset;
        }

        @Override
        public int getTagsLength() {
            return this.tagsLength;
        }

        @Override
        @Deprecated
        public byte[] getValue() {
            throw new UnsupportedOperationException("getValue() not supported");
        }

        @Override
        @Deprecated
        public byte[] getFamily() {
            throw new UnsupportedOperationException("getFamily() not supported");
        }

        @Override
        @Deprecated
        public byte[] getQualifier() {
            throw new UnsupportedOperationException("getQualifier() not supported");
        }

        @Override
        @Deprecated
        public byte[] getRow() {
            throw new UnsupportedOperationException("getRow() not supported");
        }

        public String toString() {
            return KeyValue.keyToString(this.keyBuffer, 0, KeyValueUtil.keyLength(this)) + "/vlen=" + this.getValueLength() + "/seqid=" + this.memstoreTS;
        }

        public Cell shallowCopy() {
            return new ClonedSeekerState(this.currentBuffer, this.keyBuffer, this.currentKey.getRowLength(), this.currentKey.getFamilyOffset(), this.currentKey.getFamilyLength(), this.keyLength, this.currentKey.getQualifierOffset(), this.currentKey.getQualifierLength(), this.currentKey.getTimestamp(), this.currentKey.getTypeByte(), this.valueLength, this.valueOffset, this.memstoreTS, this.tagsOffset, this.tagsLength, this.tagCompressionContext, this.tagsBuffer);
        }
    }
}

