/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.aliyun.odps.datasource;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.type.TypeInfo;
import java.sql.SQLException;
import java.util.Date;
import org.apache.spark.TaskContext$;
import org.apache.spark.aliyun.utils.OdpsUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.Decimal$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001=\u0011!b\u0014#Q'^\u0013\u0018\u000e^3s\u0015\t\u0019A!\u0001\u0006eCR\f7o\\;sG\u0016T!!\u0002\u0004\u0002\t=$\u0007o\u001d\u0006\u0003\u000f!\ta!\u00197jsVt'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\ta1+\u001a:jC2L'0\u00192mK\"A!\u0004\u0001B\u0001B\u0003%1$A\u0006bG\u000e,7o]&fs&#\u0007C\u0001\u000f \u001d\t\tR$\u0003\u0002\u001f%\u00051\u0001K]3eK\u001aL!\u0001I\u0011\u0003\rM#(/\u001b8h\u0015\tq\"\u0003\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u001c\u0003=\t7mY3tg.+\u0017pU3de\u0016$\b\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000f=$\u0007o]+sY\"Aq\u0005\u0001B\u0001B\u0003%1$A\u0005uk:tW\r\\+sY\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"RaK\u0017/_A\u0002\"\u0001\f\u0001\u000e\u0003\tAQA\u0007\u0015A\u0002mAQa\t\u0015A\u0002mAQ!\n\u0015A\u0002mAQa\n\u0015A\u0002mAqA\r\u0001C\u0002\u0013\u00051'A\u0004bG\u000e|WO\u001c;\u0016\u0003Q\u0002\"!N\u001e\u000e\u0003YR!AM\u001c\u000b\u0005\u0015A$BA\u0004:\u0015\u0005Q\u0014aA2p[&\u0011AH\u000e\u0002\u000e\u00032L\u00170\u001e8BG\u000e|WO\u001c;\t\ry\u0002\u0001\u0015!\u00035\u0003!\t7mY8v]R\u0004\u0003FA\u001fA!\t\t\u0012)\u0003\u0002C%\tIAO]1og&,g\u000e\u001e\u0005\b\u000b\u0001\u0011\r\u0011\"\u0001E+\u0005)\u0005C\u0001$H\u001b\u00059\u0014B\u0001%8\u0005\u0011yE\r]:\t\r)\u0003\u0001\u0015!\u0003F\u0003\u0015yG\r]:!Q\tI\u0005\tC\u0004N\u0001\t\u0007I\u0011\u0001(\u0002\rQ,hN\\3m+\u0005y\u0005C\u0001)S\u001b\u0005\t&BA'8\u0013\t\u0019\u0016KA\u0006UC\ndW\rV;o]\u0016d\u0007BB+\u0001A\u0003%q*A\u0004uk:tW\r\u001c\u0011)\u0005Q\u0003\u0005b\u0002-\u0001\u0005\u0004%\t!W\u0001\n_\u0012\u00048/\u0016;jYN,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001a\tQ!\u001e;jYNL!a\u0018/\u0003\u0013=#\u0007o]+uS2\u001c\bBB1\u0001A\u0003%!,\u0001\u0006pIB\u001cX\u000b^5mg\u0002B#\u0001\u0019!\t\u000f\u0011\u0004!\u0019!C\u0005K\u0006\u0019An\\4\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u0007\u0002\u000bMdg\r\u000e6\n\u0005-D'A\u0002'pO\u001e,'\u000f\u0003\u0004n\u0001\u0001\u0006IAZ\u0001\u0005Y><\u0007\u0005C\u0003p\u0001\u0011\u0005\u0001/A\u0006tCZ,Gk\u001c+bE2,G\u0003D9umb\fi\"!\t\u0002,\u0005]\u0002CA\ts\u0013\t\u0019(C\u0001\u0003V]&$\b\"B;o\u0001\u0004Y\u0012a\u00029s_*,7\r\u001e\u0005\u0006o:\u0004\raG\u0001\u0006i\u0006\u0014G.\u001a\u0005\u0006s:\u0004\rA_\u0001\u0005I\u0006$\u0018\rE\u0002|\u0003/q1\u0001`A\t\u001d\ri\u0018Q\u0002\b\u0004}\u0006-abA@\u0002\n9!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u00069\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\r\ty\u0001C\u0001\u0004gFd\u0017\u0002BA\n\u0003+\tq\u0001]1dW\u0006<WMC\u0002\u0002\u0010!IA!!\u0007\u0002\u001c\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003'\t)\u0002\u0003\u0004\u0002 9\u0004\raG\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\t\u000f\u0005\rb\u000e1\u0001\u0002&\u0005iA-\u001a4bk2$8I]3bi\u0016\u00042!EA\u0014\u0013\r\tIC\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\tiC\u001ca\u0001\u0003_\t\u0001b]1wK6{G-\u001a\t\u0005\u0003c\t\u0019$\u0004\u0002\u0002\u0016%!\u0011QGA\u000b\u0005!\u0019\u0016M^3N_\u0012,\u0007\"CA\u001d]B\u0005\t\u0019AA\u001e\u00035!\u0017P\\2QCJ$\u0018\u000e^5p]B)\u0011#!\u0010\u0002B%\u0019\u0011q\b\n\u0003\r=\u0003H/[8o!\u0015\t\u0019%a\u0013\u001c\u001d\u0011\t)%!\u0013\u000f\t\u0005\u0005\u0011qI\u0005\u0002'%\u0019\u00111\u0003\n\n\t\u00055\u0013q\n\u0002\u0004'\u0016\f(bAA\n%!I\u00111\u000b\u0001\u0012\u0002\u0013\u0005\u0011QK\u0001\u0016g\u00064X\rV8UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00138+\t\t9F\u000b\u0003\u0002<\u0005e3FAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015$#\u0001\u0006b]:|G/\u0019;j_:LA!!\u001b\u0002`\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ODPSWriter
implements Serializable {
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String odpsUrl;
    private final String tunnelUrl;
    private final transient AliyunAccount account;
    private final transient Odps odps;
    private final transient TableTunnel tunnel;
    private final transient OdpsUtils odpsUtils;
    private final Logger log;

    public AliyunAccount account() {
        return this.account;
    }

    public Odps odps() {
        return this.odps;
    }

    public TableTunnel tunnel() {
        return this.tunnel;
    }

    public OdpsUtils odpsUtils() {
        return this.odpsUtils;
    }

    private Logger log() {
        return this.log;
    }

    public void saveToTable(String project, String table, Dataset<Row> data, String partitionSpec, boolean defaultCreate, SaveMode saveMode, Option<Seq<String>> dyncPartition) {
        boolean shouldUpload;
        boolean bl;
        this.odps().setDefaultProject(project);
        boolean tableExists = this.odpsUtils().tableExist(table, project);
        boolean isPartitionTable = this.odpsUtils().isPartitionTable(table, project);
        if (isPartitionTable && partitionSpec == null) {
            throw package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"when ", ".", " is a partition table, you should provide option "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project, table}))).append((Object)"'partitionSpec'").toString());
        }
        SaveMode saveMode2 = saveMode;
        SaveMode saveMode3 = SaveMode.ErrorIfExists;
        if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null) && tableExists) {
            throw package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", " ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project, table, isPartitionTable ? partitionSpec : ""}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already exists and SaveMode is ErrorIfExists"})).s((Seq)Nil$.MODULE$)).toString());
        }
        SaveMode saveMode4 = saveMode;
        SaveMode saveMode5 = SaveMode.Ignore;
        if (!(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null) && tableExists) {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", ".", " already exists and SaveMode is Ignore, No data saved"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project, table})));
            return;
        }
        SaveMode saveMode6 = saveMode;
        SaveMode saveMode7 = SaveMode.Overwrite;
        if (!(saveMode6 != null ? !saveMode6.equals(saveMode7) : saveMode7 != null)) {
            Boolean bl2;
            if (isPartitionTable) {
                this.log().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SaveMode.Overwrite with partition Table, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop the ", " of ", ".", " first"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionSpec, project, table}))).toString());
                this.odpsUtils().dropPartition(project, table, partitionSpec);
                bl2 = BoxesRunTime.boxToBoolean((boolean)this.odpsUtils().createPartition(project, table, partitionSpec));
            } else {
                this.log().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SaveMode.Overwrite with no-partition Table, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"truncate the ", ".", " first"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project, table}))).toString());
                bl2 = this.odpsUtils().runSQL(project, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})), this.odpsUtils().runSQL$default$3());
            }
            bl = true;
        } else {
            bl = shouldUpload = true;
        }
        if (shouldUpload) {
            TableTunnel.UploadSession uploadSession;
            Object object = isPartitionTable && defaultCreate ? BoxesRunTime.boxToBoolean((boolean)this.odpsUtils().createPartition(project, table, partitionSpec)) : BoxedUnit.UNIT;
            AliyunAccount account = new AliyunAccount(this.accessKeyId, this.accessKeySecret);
            Odps odps = new Odps((Account)account);
            odps.setDefaultProject(project);
            odps.setEndpoint(this.odpsUrl);
            TableTunnel tunnel = new TableTunnel(odps);
            tunnel.setEndpoint(this.tunnelUrl);
            if (isPartitionTable) {
                PartitionSpec parSpec = new PartitionSpec(partitionSpec);
                uploadSession = tunnel.createUploadSession(project, table, parSpec);
            } else {
                uploadSession = tunnel.createUploadSession(project, table);
            }
            TableTunnel.UploadSession uploadSession2 = uploadSession;
            String uploadId = uploadSession2.getId();
            Tuple2[] dataSchema = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.odpsUtils().getTableSchema(project, table, false)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, OdpsType> apply(Tuple2<String, TypeInfo> e) {
                    return new Tuple2(e._1(), (Object)((TypeInfo)e._2()).getOdpsType());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            data.foreachPartition((Function1)new Serializable(this, project, table, partitionSpec, isPartitionTable, uploadId, dataSchema){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ODPSWriter $outer;
                private final String project$1;
                private final String table$1;
                private final String partitionSpec$1;
                private final boolean isPartitionTable$1;
                private final String uploadId$1;
                private final Tuple2[] dataSchema$1;

                public final void apply(Iterator<Row> iterator) {
                    this.$outer.org$apache$spark$aliyun$odps$datasource$ODPSWriter$$writeToFile$1(this.dataSchema$1, iterator, this.project$1, this.table$1, this.partitionSpec$1, this.isPartitionTable$1, this.uploadId$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.project$1 = project$1;
                    this.table$1 = table$1;
                    this.partitionSpec$1 = partitionSpec$1;
                    this.isPartitionTable$1 = isPartitionTable$1;
                    this.uploadId$1 = uploadId$1;
                    this.dataSchema$1 = dataSchema$1;
                }
            });
            Long[] arr = (Long[])Array$.MODULE$.tabulate(data.rdd().partitions().length, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Long apply(int l) {
                    return BoxesRunTime.boxToLong((long)l);
                }
            }, ClassTag$.MODULE$.apply(Long.class));
            uploadSession2.commit(arr);
        }
    }

    public Option<Seq<String>> saveToTable$default$7() {
        return None$.MODULE$;
    }

    public final void org$apache$spark$aliyun$odps$datasource$ODPSWriter$$writeToFile$1(Tuple2[] schema, Iterator iter, String project$1, String table$1, String partitionSpec$1, boolean isPartitionTable$1, String uploadId$1) {
        TableTunnel.UploadSession uploadSession;
        AliyunAccount account_ = new AliyunAccount(this.accessKeyId, this.accessKeySecret);
        Odps odps_ = new Odps((Account)account_);
        odps_.setDefaultProject(project$1);
        odps_.setEndpoint(this.odpsUrl);
        TableTunnel tunnel_ = new TableTunnel(odps_);
        tunnel_.setEndpoint(this.tunnelUrl);
        if (isPartitionTable$1) {
            PartitionSpec parSpec = new PartitionSpec(partitionSpec$1);
            uploadSession = tunnel_.getUploadSession(project$1, table$1, parSpec, uploadId$1);
        } else {
            uploadSession = tunnel_.getUploadSession(project$1, table$1, uploadId$1);
        }
        TableTunnel.UploadSession uploadSession_ = uploadSession;
        RecordWriter writer = uploadSession_.openRecordWriter((long)TaskContext$.MODULE$.get().partitionId());
        long recordsWritten = 0L;
        while (iter.hasNext()) {
            Row value = (Row)iter.next();
            Record record = uploadSession_.newRecord();
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, value, record){
                public static final long serialVersionUID = 0L;
                private final Row value$1;
                private final Record record$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void apply(Tuple2<Tuple2<String, OdpsType>, Object> x0$1) {
                    BoxedUnit boxedUnit;
                    Tuple2<Tuple2<String, OdpsType>, Object> tuple22 = x0$1;
                    if (tuple22 == null) throw new MatchError(tuple22);
                    Tuple2 s = (Tuple2)tuple22._1();
                    int idx = tuple22._2$mcI$sp();
                    if (s == null) throw new MatchError(tuple22);
                    Tuple2 tuple2 = s;
                    int n = idx;
                    try {
                        OdpsType odpsType = (OdpsType)tuple2._2();
                        if (OdpsType.BIGINT.equals(odpsType)) {
                            this.record$1.setBigint((String)tuple2._1(), Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(this.value$1.get(n).toString())).toLong()));
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        } else if (OdpsType.BINARY.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), (Object)new Binary((byte[])this.value$1.getAs(n)));
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        } else if (OdpsType.BOOLEAN.equals(odpsType)) {
                            this.record$1.setBoolean((String)tuple2._1(), Predef$.MODULE$.boolean2Boolean(this.value$1.getBoolean(n)));
                            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                        } else if (OdpsType.CHAR.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), (Object)new Char(this.value$1.get(n).toString()));
                            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                        } else if (OdpsType.DATE.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), this.value$1.getAs(n));
                            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                        } else if (OdpsType.DATETIME.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), (Object)new Date(((Date)this.value$1.getAs(n)).getTime()));
                            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                        } else if (OdpsType.DECIMAL.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), (Object)Decimal$.MODULE$.apply(this.value$1.get(n).toString()).toJavaBigDecimal());
                            BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                        } else if (OdpsType.DOUBLE.equals(odpsType)) {
                            this.record$1.setDouble((String)tuple2._1(), Predef$.MODULE$.double2Double(this.value$1.getDouble(n)));
                            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                        } else if (OdpsType.FLOAT.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), (Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(this.value$1.get(n).toString())).toFloat()));
                            BoxedUnit boxedUnit10 = BoxedUnit.UNIT;
                        } else if (OdpsType.INT.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(this.value$1.get(n).toString())).toInt()));
                            BoxedUnit boxedUnit11 = BoxedUnit.UNIT;
                        } else if (OdpsType.SMALLINT.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), (Object)BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(this.value$1.get(n).toString())).toShort()));
                            BoxedUnit boxedUnit12 = BoxedUnit.UNIT;
                        } else if (OdpsType.STRING.equals(odpsType)) {
                            this.record$1.setString((String)tuple2._1(), this.value$1.get(n).toString());
                            BoxedUnit boxedUnit13 = BoxedUnit.UNIT;
                        } else if (OdpsType.TINYINT.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), this.value$1.getAs(n));
                            BoxedUnit boxedUnit14 = BoxedUnit.UNIT;
                        } else if (OdpsType.VARCHAR.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), (Object)new Varchar(this.value$1.get(n).toString()));
                            BoxedUnit boxedUnit15 = BoxedUnit.UNIT;
                        } else if (OdpsType.TIMESTAMP.equals(odpsType)) {
                            this.record$1.setDatetime((String)tuple2._1(), (Date)this.value$1.getAs(n));
                            BoxedUnit boxedUnit16 = BoxedUnit.UNIT;
                        } else if (OdpsType.VOID.equals(odpsType)) {
                            this.record$1.set((String)tuple2._1(), null);
                            BoxedUnit boxedUnit17 = BoxedUnit.UNIT;
                        } else {
                            if (OdpsType.INTERVAL_DAY_TIME.equals(odpsType)) {
                                throw new SQLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type 'INTERVAL_DAY_TIME'"})).s((Seq)Nil$.MODULE$));
                            }
                            if (OdpsType.INTERVAL_YEAR_MONTH.equals(odpsType)) {
                                throw new SQLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type 'INTERVAL_YEAR_MONTH'"})).s((Seq)Nil$.MODULE$));
                            }
                            if (OdpsType.MAP.equals(odpsType)) {
                                throw new SQLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type 'MAP'"})).s((Seq)Nil$.MODULE$));
                            }
                            if (OdpsType.STRUCT.equals(odpsType)) {
                                throw new SQLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type 'STRUCT'"})).s((Seq)Nil$.MODULE$));
                            }
                            if (!OdpsType.ARRAY.equals(odpsType)) throw new SQLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._2()})));
                            throw new SQLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type 'ARRAY'"})).s((Seq)Nil$.MODULE$));
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (NullPointerException nullPointerException22) {
                        if (this.value$1.get(n) != null) throw nullPointerException22;
                        this.record$1.set((String)tuple2._1(), null);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit18 = boxedUnit;
                }
                {
                    this.value$1 = value$1;
                    this.record$1 = record$1;
                }
            });
            writer.write(record);
            ++recordsWritten;
        }
        writer.close();
    }

    public ODPSWriter(String accessKeyId, String accessKeySecret, String odpsUrl, String tunnelUrl) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.odpsUrl = odpsUrl;
        this.tunnelUrl = tunnelUrl;
        this.account = new AliyunAccount(accessKeyId, accessKeySecret);
        this.odps = new Odps((Account)this.account());
        this.odps().setEndpoint(odpsUrl);
        this.tunnel = new TableTunnel(this.odps());
        this.tunnel().setEndpoint(tunnelUrl);
        this.odpsUtils = new OdpsUtils(this.odps());
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

