/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.exception;

import com.alibaba.cola.dto.ErrorCodeI;
import com.alibaba.cola.exception.BizException;
import com.alibaba.cola.exception.framework.BasicErrorCode;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public abstract class Assert {
    public static void isTrue(boolean expression, ErrorCodeI errorCode, String message) {
        if (!expression) {
            throw new BizException(errorCode, message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        Assert.isTrue(expression, BasicErrorCode.BIZ_ERROR, message);
    }

    public static void isTrue(boolean expression) {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void notNull(Object object, ErrorCodeI errorCode, String message) {
        if (object == null) {
            throw new BizException(errorCode, message);
        }
    }

    public static void notNull(Object object, String message) {
        Assert.notNull(object, BasicErrorCode.BIZ_ERROR, message);
    }

    public static void notNull(Object object) {
        Assert.notNull(object, BasicErrorCode.BIZ_ERROR, "[Assertion failed] - the argument " + object + " must not be null");
    }

    public static void notEmpty(Collection<?> collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Collection<?> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BizException(message);
        }
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        if (CollectionUtils.isEmpty(map)) {
            throw new BizException(message);
        }
    }

    public static void notEmpty(Map<?, ?> map) {
        Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }
}

