/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.BasicCredentials;
import com.aliyuncs.auth.BasicSessionCredentials;
import com.aliyuncs.auth.InstanceProfileCredentialsProvider;
import com.aliyuncs.auth.OIDCCredentialsProvider;
import com.aliyuncs.auth.STSAssumeRoleSessionCredentialsProvider;
import com.aliyuncs.auth.StaticCredentialsProvider;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.utils.AuthUtils;
import com.aliyuncs.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class CLIProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private final String CLI_CREDENTIALS_CONFIG_PATH = System.getProperty("user.home") + "/.aliyun/config.json";
    private volatile AlibabaCloudCredentialsProvider credentialsProvider;
    private volatile String currentProfileName;
    private final Object credentialsProviderLock = new Object();

    private CLIProfileCredentialsProvider(Builder builder) {
        this.currentProfileName = builder.profileName == null ? System.getenv("ALIBABA_CLOUD_PROFILE") : builder.profileName;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        if (AuthUtils.isDisableCLIProfile()) {
            throw new ClientException("CLI credentials file is disabled.");
        }
        Config config = null;
        try {
            config = this.parseProfile(this.CLI_CREDENTIALS_CONFIG_PATH);
        }
        catch (IOException e) {
            throw new ClientException("Unable to get profile from CLI credentials file: " + e);
        }
        if (null == config) {
            throw new ClientException("Unable to get profile from empty CLI credentials file.");
        }
        String refreshedProfileName = System.getenv("ALIBABA_CLOUD_PROFILE");
        if (this.shouldReloadCredentialsProvider(refreshedProfileName)) {
            Object object = this.credentialsProviderLock;
            synchronized (object) {
                if (this.shouldReloadCredentialsProvider(refreshedProfileName)) {
                    if (!StringUtils.isEmpty(refreshedProfileName)) {
                        this.currentProfileName = refreshedProfileName;
                    }
                    this.credentialsProvider = this.reloadCredentialsProvider(config, this.currentProfileName);
                }
            }
        }
        return this.credentialsProvider.getCredentials();
    }

    AlibabaCloudCredentialsProvider reloadCredentialsProvider(Config config, String profileName) throws ClientException {
        String currentProfileName = !StringUtils.isEmpty(profileName) ? profileName : config.getCurrent();
        List<Profile> profiles = config.getProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            for (Profile profile : profiles) {
                if (StringUtils.isEmpty(profile.getName()) || !profile.getName().equals(currentProfileName)) continue;
                String mode = profile.getMode();
                if ("AK".equals(mode)) {
                    return new StaticCredentialsProvider(new BasicCredentials(profile.getAccessKeyId(), profile.getAccessKeySecret()));
                }
                if ("StsToken".equals(mode)) {
                    return new StaticCredentialsProvider(new BasicSessionCredentials(profile.getAccessKeyId(), profile.getAccessKeySecret(), profile.getSecurityToken()));
                }
                if ("RamRoleArn".equals(mode)) {
                    StaticCredentialsProvider innerProvider = new StaticCredentialsProvider(new BasicCredentials(profile.getAccessKeyId(), profile.getAccessKeySecret()));
                    return STSAssumeRoleSessionCredentialsProvider.builder().credentialsProvider(innerProvider).durationSeconds(profile.getDurationSeconds()).roleArn(profile.getRoleArn()).roleSessionName(profile.getRoleSessionName()).stsRegionId(profile.getStsRegionId()).enableVpc(profile.getEnableVpc()).policy(profile.getPolicy()).externalId(profile.getExternalId()).build();
                }
                if ("EcsRamRole".equals(mode)) {
                    return InstanceProfileCredentialsProvider.builder().roleName(profile.getRamRoleName()).build();
                }
                if ("OIDC".equals(mode)) {
                    return OIDCCredentialsProvider.builder().durationSeconds(profile.getDurationSeconds()).roleArn(profile.getRoleArn()).roleSessionName(profile.getRoleSessionName()).oidcProviderArn(profile.getOidcProviderArn()).oidcTokenFilePath(profile.getOidcTokenFile()).stsRegionId(profile.getStsRegionId()).enableVpc(profile.getEnableVpc()).policy(profile.getPolicy()).build();
                }
                if ("ChainableRamRoleArn".equals(mode)) {
                    AlibabaCloudCredentialsProvider previousProvider = this.reloadCredentialsProvider(config, profile.getSourceProfile());
                    return STSAssumeRoleSessionCredentialsProvider.builder().credentialsProvider(previousProvider).durationSeconds(profile.getDurationSeconds()).roleArn(profile.getRoleArn()).roleSessionName(profile.getRoleSessionName()).stsRegionId(profile.getStsRegionId()).enableVpc(profile.getEnableVpc()).policy(profile.getPolicy()).externalId(profile.getExternalId()).build();
                }
                throw new ClientException(String.format("Unsupported profile mode '%s' form CLI credentials file.", mode));
            }
        }
        throw new ClientException(String.format("Unable to get profile with '%s' form CLI credentials file.", currentProfileName));
    }

    Config parseProfile(String configFilePath) throws ClientException, IOException {
        File configFile = new File(configFilePath);
        if (!(configFile.exists() && configFile.isFile() && configFile.canRead())) {
            throw new ClientException(String.format("Unable to open credentials file: %s.", configFile.getAbsolutePath()));
        }
        Gson gson = new Gson();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(configFile));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String jsonContent = sb.toString();
            Config config = (Config)gson.fromJson(jsonContent, Config.class);
            return config;
        }
        catch (Exception e) {
            throw new ClientException(String.format("Failed to parse credential form CLI credentials file: %s.", configFile.getAbsolutePath()));
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    boolean shouldReloadCredentialsProvider(String profileName) {
        return this.credentialsProvider == null || !StringUtils.isEmpty(this.currentProfileName) && !StringUtils.isEmpty(profileName) && !this.currentProfileName.equals(profileName);
    }

    String getProfileName() {
        return this.currentProfileName;
    }

    static class Profile {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="mode")
        private String mode;
        @SerializedName(value="access_key_id")
        private String accessKeyId;
        @SerializedName(value="access_key_secret")
        private String accessKeySecret;
        @SerializedName(value="sts_token")
        private String securityToken;
        @SerializedName(value="ram_role_arn")
        private String roleArn;
        @SerializedName(value="ram_session_name")
        private String roleSessionName;
        @SerializedName(value="expired_seconds")
        private Integer durationSeconds;
        @SerializedName(value="sts_region")
        private String stsRegionId;
        @SerializedName(value="enable_vpc")
        private Boolean enableVpc;
        @SerializedName(value="ram_role_name")
        private String ramRoleName;
        @SerializedName(value="oidc_token_file")
        private String oidcTokenFile;
        @SerializedName(value="oidc_provider_arn")
        private String oidcProviderArn;
        @SerializedName(value="source_profile")
        private String sourceProfile;
        @SerializedName(value="policy")
        private String policy;
        @SerializedName(value="external_id")
        private String externalId;

        Profile() {
        }

        public String getName() {
            return this.name;
        }

        public String getMode() {
            return this.mode;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public String getSecurityToken() {
            return this.securityToken;
        }

        public String getRoleArn() {
            return this.roleArn;
        }

        public String getRoleSessionName() {
            return this.roleSessionName;
        }

        public Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public String getStsRegionId() {
            return this.stsRegionId;
        }

        public Boolean getEnableVpc() {
            return this.enableVpc;
        }

        public String getRamRoleName() {
            return this.ramRoleName;
        }

        public String getOidcTokenFile() {
            return this.oidcTokenFile;
        }

        public String getOidcProviderArn() {
            return this.oidcProviderArn;
        }

        public String getSourceProfile() {
            return this.sourceProfile;
        }

        public String getPolicy() {
            return this.policy;
        }

        public String getExternalId() {
            return this.externalId;
        }
    }

    static class Config {
        @SerializedName(value="current")
        private String current;
        @SerializedName(value="profiles")
        private List<Profile> profiles;

        Config() {
        }

        public String getCurrent() {
            return this.current;
        }

        public List<Profile> getProfiles() {
            return this.profiles;
        }
    }

    static final class Builder {
        private String profileName;

        Builder() {
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        CLIProfileCredentialsProvider build() {
            return new CLIProfileCredentialsProvider(this);
        }
    }
}

