package com.alipay.api.response;

import java.util.Date;
import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.FundBill;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.commerce.transport.vehicleowner.settlement.query response.
 * 
 * @author auto create
 * @since 1.0, 2019-06-23 10:50:01
 */
public class AlipayCommerceTransportVehicleownerSettlementQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 3168419738571818652L;

	/** 
	 * 买家支付宝账户
	 */
	@ApiField("buyer_id")
	private String buyerId;

	/** 
	 * 平台优惠金额
	 */
	@ApiField("discount_amount")
	private String discountAmount;

	/** 
	 * 交易支付使用的资金渠道
	 */
	@ApiListField("fund_bill_list")
	@ApiField("fund_bill")
	private List<FundBill> fundBillList;

	/** 
	 * 商家优惠金额
	 */
	@ApiField("m_discount_amount")
	private String mDiscountAmount;

	/** 
	 * 商户订单号
	 */
	@ApiField("out_trade_no")
	private String outTradeNo;

	/** 
	 * 打款给卖家的时间
	 */
	@ApiField("send_pay_date")
	private Date sendPayDate;

	/** 
	 * 订单状态:
"I":"待支付";
"PI":"支付中";
"S":"支付成功";
"F":"支付失败";
"RI":"退款中";
"R":"已退款".
	 */
	@ApiField("status")
	private String status;

	/** 
	 * 订单金额
	 */
	@ApiField("total_amount")
	private String totalAmount;

	/** 
	 * 支付宝交易号
	 */
	@ApiField("trade_no")
	private String tradeNo;

	public void setBuyerId(String buyerId) {
		this.buyerId = buyerId;
	}
	public String getBuyerId( ) {
		return this.buyerId;
	}

	public void setDiscountAmount(String discountAmount) {
		this.discountAmount = discountAmount;
	}
	public String getDiscountAmount( ) {
		return this.discountAmount;
	}

	public void setFundBillList(List<FundBill> fundBillList) {
		this.fundBillList = fundBillList;
	}
	public List<FundBill> getFundBillList( ) {
		return this.fundBillList;
	}

	public void setmDiscountAmount(String mDiscountAmount) {
		this.mDiscountAmount = mDiscountAmount;
	}
	public String getmDiscountAmount( ) {
		return this.mDiscountAmount;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}
	public String getOutTradeNo( ) {
		return this.outTradeNo;
	}

	public void setSendPayDate(Date sendPayDate) {
		this.sendPayDate = sendPayDate;
	}
	public Date getSendPayDate( ) {
		return this.sendPayDate;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	public String getStatus( ) {
		return this.status;
	}

	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}
	public String getTotalAmount( ) {
		return this.totalAmount;
	}

	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}
	public String getTradeNo( ) {
		return this.tradeNo;
	}

}
