/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kms.aliyun;

import com.alipay.easysdk.kernel.AlipayConstants;
import com.alipay.easysdk.kms.aliyun.AliyunRpcClient;
import com.alipay.easysdk.kms.aliyun.models.AsymmetricSignRequest;
import com.alipay.easysdk.kms.aliyun.models.AsymmetricSignResponse;
import com.alipay.easysdk.kms.aliyun.models.GetPublicKeyRequest;
import com.alipay.easysdk.kms.aliyun.models.GetPublicKeyResponse;
import com.alipay.easysdk.kms.aliyun.models.RuntimeOptions;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.util.encoders.Base64;

public class AliyunKMSClient
extends AliyunRpcClient {
    private String keyId;
    private String keyVersionId;
    private String algorithm;
    private PublicKey publicKey;
    private String protocol;
    private String method;
    private String version;
    private Integer connectTimeout;
    private Integer readTimeout;
    private Integer maxAttempts;
    private boolean ignoreSSL;
    private static final Map<String, String> signAlgs = new HashMap<String, String>();
    private static final Map<String, String> digestAlgs = new HashMap<String, String>();
    private static final Map<String, String> namedCurves = new HashMap<String, String>();

    public AliyunKMSClient(Map<String, Object> config) {
        super(config);
        this.keyId = (String)config.get("kmsKeyId");
        this.keyVersionId = (String)config.get("kmsKeyVersionId");
        this.algorithm = signAlgs.get((String)config.get("signType"));
        this.publicKey = null;
        this.protocol = "HTTPS";
        this.method = "POST";
        this.version = "2016-01-20";
        this.connectTimeout = 15000;
        this.readTimeout = 15000;
        this.maxAttempts = 3;
        this.ignoreSSL = false;
    }

    private GetPublicKeyResponse _getPublicKey(GetPublicKeyRequest request) throws Exception {
        AliyunKMSClient.validateModel(request);
        RuntimeOptions runtime = RuntimeOptions.build(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("connectTimeout", (Object)this.connectTimeout), new TeaPair("readTimeout", (Object)this.readTimeout), new TeaPair("maxAttempts", (Object)this.maxAttempts), new TeaPair("ignoreSSL", (Object)this.ignoreSSL)}));
        return (GetPublicKeyResponse)TeaModel.toModel(this.doRequest("GetPublicKey", this.protocol, this.method, this.version, TeaModel.buildMap((TeaModel)request), null, runtime), (TeaModel)new GetPublicKeyResponse());
    }

    private PublicKey getPublicKey(String keyId, String keyVersionId) throws Exception {
        GetPublicKeyRequest request = GetPublicKeyRequest.build(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("KeyId", (Object)keyId), new TeaPair("KeyVersionId", (Object)keyVersionId)}));
        GetPublicKeyResponse response = this._getPublicKey(request);
        String pemKey = response.publicKey;
        pemKey = pemKey.replaceFirst("-----BEGIN PUBLIC KEY-----", "");
        pemKey = pemKey.replaceFirst("-----END PUBLIC KEY-----", "");
        pemKey = pemKey.replaceAll("\\s", "");
        byte[] derKey = Base64.decode((String)pemKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(derKey);
        Security.addProvider((Provider)new BouncyCastleProvider());
        return KeyFactory.getInstance("EC", "BC").generatePublic(keySpec);
    }

    private byte[] getZ(ECPublicKeyParameters ecPublicKeyParameters, ECDomainParameters ecDomainParameters) {
        SM3Digest digest = new SM3Digest();
        digest.reset();
        String userID = "1234567812345678";
        this.addUserID((Digest)digest, userID.getBytes());
        this.addFieldElement((Digest)digest, ecDomainParameters.getCurve().getA());
        this.addFieldElement((Digest)digest, ecDomainParameters.getCurve().getB());
        this.addFieldElement((Digest)digest, ecDomainParameters.getG().getAffineXCoord());
        this.addFieldElement((Digest)digest, ecDomainParameters.getG().getAffineYCoord());
        this.addFieldElement((Digest)digest, ecPublicKeyParameters.getQ().getAffineXCoord());
        this.addFieldElement((Digest)digest, ecPublicKeyParameters.getQ().getAffineYCoord());
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    private void addUserID(Digest digest, byte[] userID) {
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
    }

    private void addFieldElement(Digest digest, ECFieldElement v) {
        byte[] p = v.getEncoded();
        digest.update(p, 0, p.length);
    }

    private byte[] calcSM3Digest(PublicKey pubKey, byte[] message) {
        X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)namedCurves.get(this.algorithm));
        ECDomainParameters ecDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
        BCECPublicKey localECPublicKey = (BCECPublicKey)pubKey;
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), ecDomainParameters);
        byte[] z = this.getZ(ecPublicKeyParameters, ecDomainParameters);
        SM3Digest digest = new SM3Digest();
        digest.update(z, 0, z.length);
        digest.update(message, 0, message.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    private AsymmetricSignResponse _asymmetricSign(AsymmetricSignRequest request) throws Exception {
        AliyunKMSClient.validateModel(request);
        RuntimeOptions runtime = RuntimeOptions.build(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("connectTimeout", (Object)this.connectTimeout), new TeaPair("readTimeout", (Object)this.readTimeout), new TeaPair("maxAttempts", (Object)this.maxAttempts), new TeaPair("ignoreSSL", (Object)this.ignoreSSL)}));
        return (AsymmetricSignResponse)TeaModel.toModel(this.doRequest("AsymmetricSign", this.protocol, this.method, this.version, TeaModel.buildMap((TeaModel)request), null, runtime), (TeaModel)new AsymmetricSignResponse());
    }

    private String asymmetricSign(String keyId, String keyVersionId, String algorithm, byte[] message) throws Exception {
        byte[] digest;
        if (algorithm.equals("SM2DSA")) {
            if (this.publicKey == null) {
                this.publicKey = this.getPublicKey(keyId, keyVersionId);
            }
            digest = this.calcSM3Digest(this.publicKey, message);
        } else {
            digest = MessageDigest.getInstance(digestAlgs.get(algorithm)).digest(message);
        }
        AsymmetricSignRequest request = AsymmetricSignRequest.build(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("keyId", (Object)keyId), new TeaPair("keyVersionId", (Object)keyVersionId), new TeaPair("algorithm", (Object)algorithm), new TeaPair("digest", (Object)new String(Base64.encode((byte[])digest)))}));
        AsymmetricSignResponse response = this._asymmetricSign(request);
        return response.value;
    }

    public String sign(String content) throws Exception {
        return this.asymmetricSign(this.keyId, this.keyVersionId, this.algorithm, content.getBytes(AlipayConstants.DEFAULT_CHARSET));
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public void setKeyVersionId(String keyVersionId) {
        this.keyVersionId = keyVersionId;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public boolean getIgnoreSSL() {
        return this.ignoreSSL;
    }

    public void setIgnoreSSL(boolean ignoreSSL) {
        this.ignoreSSL = ignoreSSL;
    }

    static {
        digestAlgs.put("RSA_PKCS1_SHA_256", "SHA-256");
        digestAlgs.put("RSA_PSS_SHA_256", "SHA-256");
        digestAlgs.put("ECDSA_SHA_256", "SHA-256");
        namedCurves.put("SM2DSA", "sm2p256v1");
        signAlgs.put("RSA2", "RSA_PKCS1_SHA_256");
    }
}

