/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.anno.method.ClassUtil;
import com.alicp.jetcache.anno.support.CacheNameGenerator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class DefaultCacheNameGenerator
implements CacheNameGenerator {
    protected final String[] hiddenPackages;
    protected final ConcurrentHashMap<Method, String> cacheNameMap = new ConcurrentHashMap();

    public DefaultCacheNameGenerator(String[] hiddenPackages) {
        this.hiddenPackages = hiddenPackages;
    }

    @Override
    public String generateCacheName(Method method, Object targetObject) {
        String cacheName = this.cacheNameMap.get(method);
        if (cacheName == null) {
            StringBuilder sb = new StringBuilder();
            String className = method.getDeclaringClass().getName();
            sb.append(ClassUtil.getShortClassName(this.removeHiddenPackage(this.hiddenPackages, className)));
            sb.append('.');
            sb.append(method.getName());
            sb.append('(');
            for (Class<?> c : method.getParameterTypes()) {
                this.getDescriptor(sb, c, this.hiddenPackages);
            }
            sb.append(')');
            String str = sb.toString();
            this.cacheNameMap.put(method, str);
            return str;
        }
        return cacheName;
    }

    @Override
    public String generateCacheName(Field field) {
        StringBuilder sb = new StringBuilder();
        String className = field.getDeclaringClass().getName();
        className = this.removeHiddenPackage(this.hiddenPackages, className);
        className = ClassUtil.getShortClassName(className);
        sb.append(className);
        sb.append(".").append(field.getName());
        return sb.toString();
    }

    protected String removeHiddenPackage(String[] hiddenPackages, String packageOrFullClassName) {
        if (hiddenPackages != null && packageOrFullClassName != null) {
            for (String p : hiddenPackages) {
                if (p == null || !packageOrFullClassName.startsWith(p)) continue;
                packageOrFullClassName = Pattern.compile(p, 16).matcher(packageOrFullClassName).replaceFirst("");
                if (packageOrFullClassName.length() > 0 && packageOrFullClassName.charAt(0) == '.') {
                    packageOrFullClassName = packageOrFullClassName.substring(1);
                }
                return packageOrFullClassName;
            }
        }
        return packageOrFullClassName;
    }

    protected void getDescriptor(StringBuilder sb, Class<?> c, String[] hiddenPackages) {
        Class<?> d = c;
        while (true) {
            if (d.isPrimitive()) {
                int car = d == Integer.TYPE ? 73 : (d == Void.TYPE ? 86 : (d == Boolean.TYPE ? 90 : (d == Byte.TYPE ? 66 : (d == Character.TYPE ? 67 : (d == Short.TYPE ? 83 : (d == Double.TYPE ? 68 : (d == Float.TYPE ? 70 : 74)))))));
                sb.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            sb.append('[');
            d = d.getComponentType();
        }
        sb.append('L');
        String name = d.getName();
        name = this.removeHiddenPackage(hiddenPackages, name);
        name = ClassUtil.getShortClassName(name);
        sb.append(name);
        sb.append(';');
    }
}

