/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AnnotationUtils {
    public static <A extends Annotation> boolean isPresent(Method method, Class<A> annotationClass) {
        Map<ElementType, List<A>> annotationsMap = AnnotationUtils.findAnnotations(method, annotationClass);
        return !annotationsMap.isEmpty();
    }

    public static <A extends Annotation> Map<ElementType, List<A>> findAnnotations(Method method, Class<A> annotationClass) {
        ElementType[] elementTypes;
        Retention retention = annotationClass.getAnnotation(Retention.class);
        RetentionPolicy retentionPolicy = retention.value();
        if (!RetentionPolicy.RUNTIME.equals((Object)retentionPolicy)) {
            return Collections.emptyMap();
        }
        LinkedHashMap annotationsMap = new LinkedHashMap();
        Target target = annotationClass.getAnnotation(Target.class);
        for (ElementType elementType : elementTypes = target.value()) {
            LinkedList<Annotation> annotationsList = new LinkedList<Annotation>();
            switch (elementType) {
                case PARAMETER: {
                    Annotation[][] parameterAnnotations;
                    Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation[] annotations;
                        for (Annotation annotation : annotations = annotationArray[i]) {
                            if (!annotationClass.equals(annotation.annotationType())) continue;
                            annotationsList.add(annotation);
                        }
                    }
                    break;
                }
                case METHOD: {
                    Annotation annotation = org.springframework.core.annotation.AnnotationUtils.findAnnotation((Method)method, annotationClass);
                    if (annotation == null) break;
                    annotationsList.add(annotation);
                    break;
                }
                case TYPE: {
                    Class<?> beanType = method.getDeclaringClass();
                    Annotation annotation2 = org.springframework.core.annotation.AnnotationUtils.findAnnotation(beanType, annotationClass);
                    if (annotation2 == null) break;
                    annotationsList.add(annotation2);
                }
            }
            if (annotationsList.isEmpty()) continue;
            annotationsMap.put(elementType, annotationsList);
        }
        return Collections.unmodifiableMap(annotationsMap);
    }

    public static Map<String, Object> getAttributes(Annotation annotation, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAttributes(annotation, null, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static Map<String, Object> getAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        HashSet ignoreAttributeNamesSet = new HashSet(CollectionUtils.arrayToList((Object)ignoreAttributeNames));
        Map attributes = org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
        LinkedHashMap<String, Object> actualAttributes = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            if (ignoreDefaultValue && ObjectUtils.nullSafeEquals(attributeValue, (Object)org.springframework.core.annotation.AnnotationUtils.getDefaultValue((Annotation)annotation, (String)attributeName)) || ignoreAttributeNamesSet.contains(attributeName)) continue;
            if (attributeValue instanceof String) {
                attributeValue = AnnotationUtils.resolvePlaceholders(String.valueOf(attributeValue), propertyResolver);
            } else if (attributeValue instanceof String[]) {
                String[] values = (String[])attributeValue;
                for (int i = 0; i < values.length; ++i) {
                    values[i] = AnnotationUtils.resolvePlaceholders(values[i], propertyResolver);
                }
                attributeValue = values;
            }
            actualAttributes.put(attributeName, attributeValue);
        }
        return actualAttributes;
    }

    private static String resolvePlaceholders(String attributeValue, PropertyResolver propertyResolver) {
        String resolvedValue = attributeValue;
        if (propertyResolver != null) {
            resolvedValue = propertyResolver.resolvePlaceholders(resolvedValue);
            resolvedValue = StringUtils.trimWhitespace((String)resolvedValue);
        }
        return resolvedValue;
    }
}

