/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.stats;

import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.protocol.body.BrokerStatsData;
import com.alibaba.rocketmq.common.protocol.body.GroupList;
import com.alibaba.rocketmq.common.protocol.body.TopicList;
import com.alibaba.rocketmq.common.protocol.route.BrokerData;
import com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.MQAdminStartup;
import com.alibaba.rocketmq.tools.command.SubCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class StatsAllSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "statsAll";
    }

    @Override
    public String commandDesc() {
        return "Topic and Consumer tps stats";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("a", "activeTopic", false, "print active topic only");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static long compute24HourSum(BrokerStatsData bsd) {
        if (bsd.getStatsDay().getSum() != 0L) {
            return bsd.getStatsDay().getSum();
        }
        if (bsd.getStatsHour().getSum() != 0L) {
            return bsd.getStatsHour().getSum();
        }
        if (bsd.getStatsMinute().getSum() != 0L) {
            return bsd.getStatsMinute().getSum();
        }
        return 0L;
    }

    public static void printTopicDetail(DefaultMQAdminExt admin, String topic, boolean activeTopic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        TopicRouteData topicRouteData = admin.examineTopicRouteInfo(topic);
        GroupList groupList = admin.queryTopicConsumeByWho(topic);
        double inTPS = 0.0;
        long inMsgCntToday = 0L;
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String masterAddr = (String)bd.getBrokerAddrs().get(0L);
            if (masterAddr == null) continue;
            try {
                BrokerStatsData bsd = admin.ViewBrokerStatsData(masterAddr, "TOPIC_PUT_NUMS", topic);
                inTPS += bsd.getStatsMinute().getTps();
                inMsgCntToday += StatsAllSubCommand.compute24HourSum(bsd);
            }
            catch (Exception e) {}
        }
        if (groupList != null && !groupList.getGroupList().isEmpty()) {
            for (String group : groupList.getGroupList()) {
                double outTPS = 0.0;
                long outMsgCntToday = 0L;
                for (BrokerData bd : topicRouteData.getBrokerDatas()) {
                    String masterAddr = (String)bd.getBrokerAddrs().get(0L);
                    if (masterAddr == null) continue;
                    try {
                        String statsKey = String.format("%s@%s", topic, group);
                        BrokerStatsData bsd = admin.ViewBrokerStatsData(masterAddr, "GROUP_GET_NUMS", statsKey);
                        outTPS += bsd.getStatsMinute().getTps();
                        outMsgCntToday += StatsAllSubCommand.compute24HourSum(bsd);
                    }
                    catch (Exception e) {}
                }
                if (activeTopic && inMsgCntToday <= 0L && outMsgCntToday <= 0L) continue;
                System.out.printf("%-32s  %-32s %11.2f %11.2f %14d %14d\n", UtilAll.frontStringAtLeast((String)topic, (int)32), UtilAll.frontStringAtLeast((String)group, (int)32), inTPS, outTPS, inMsgCntToday, outMsgCntToday);
            }
        } else if (!activeTopic || inMsgCntToday > 0L) {
            System.out.printf("%-32s  %-32s %11.2f %11s %14d %14s\n", UtilAll.frontStringAtLeast((String)topic, (int)32), "", inTPS, "", inMsgCntToday, "NO_CONSUMER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            TopicList topicList = defaultMQAdminExt.fetchAllTopicList();
            System.out.printf("%-32s  %-32s %11s %11s %14s %14s\n", "#Topic", "#Consumer Group", "#InTPS", "#OutTPS", "#InMsg24Hour", "#OutMsg24Hour");
            boolean activeTopic = commandLine.hasOption('a');
            for (String topic : topicList.getTopicList()) {
                if (topic.startsWith("%RETRY%") || topic.startsWith("%DLQ%")) continue;
                try {
                    StatsAllSubCommand.printTopicDetail(defaultMQAdminExt, topic, activeTopic);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    public static void main(String[] args) {
        System.setProperty("rocketmq.namesrv.addr", "10.101.87.102:9876");
        MQAdminStartup.main(new String[]{new StatsAllSubCommand().commandName()});
    }
}

