/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.offset;

import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.srvutil.ServerUtil;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import com.alibaba.rocketmq.tools.command.offset.ResetOffsetByTimeOldCommand;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class ResetOffsetByTimeCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "resetOffsetByTime";
    }

    @Override
    public String commandDesc() {
        return "Reset consumer offset by timestamp(without client restart).";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("g", "group", true, "set the consumer group");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "set the topic");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("s", "timestamp", true, "set the timestamp[currentTimeMillis|yyyy-MM-dd#HH:mm:ss:SSS]");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("f", "force", true, "set the force rollback by timestamp switch[true|false]");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        Map<MessageQueue, Long> offsetTable;
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String group = commandLine.getOptionValue("g").trim();
            String topic = commandLine.getOptionValue("t").trim();
            String timeStampStr = commandLine.getOptionValue("s").trim();
            long timestamp = 0L;
            try {
                timestamp = Long.valueOf(timeStampStr);
            }
            catch (NumberFormatException e) {
                timestamp = UtilAll.parseDate((String)timeStampStr, (String)"yyyy-MM-dd#HH:mm:ss:SSS").getTime();
            }
            boolean force = true;
            if (commandLine.hasOption('f')) {
                force = Boolean.valueOf(commandLine.getOptionValue("f").trim());
            }
            defaultMQAdminExt.start();
            try {
                offsetTable = defaultMQAdminExt.resetOffsetByTimestamp(topic, group, timestamp, force);
            }
            catch (MQClientException e) {
                if (206 == e.getResponseCode()) {
                    ResetOffsetByTimeOldCommand.resetOffset(defaultMQAdminExt, group, topic, timestamp, force, timeStampStr);
                    defaultMQAdminExt.shutdown();
                    return;
                }
                throw e;
            }
            System.out.printf("rollback consumer offset by specified group[%s], topic[%s], force[%s], timestamp(string)[%s], timestamp(long)[%s]\n", group, topic, force, timeStampStr, timestamp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
        System.out.printf("%-40s  %-40s  %-40s\n", "#brokerName", "#queueId", "#offset");
        for (Map.Entry<MessageQueue, Long> entry : offsetTable.entrySet()) {
            System.out.printf("%-40s  %-40d  %-40d\n", UtilAll.frontStringAtLeast((String)entry.getKey().getBrokerName(), (int)32), entry.getKey().getQueueId(), entry.getValue());
        }
    }

    public static void main(String[] args) {
        System.setProperty("rocketmq.namesrv.addr", "127.0.0.1:9876");
        ResetOffsetByTimeCommand cmd = new ResetOffsetByTimeCommand();
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        String[] subargs = new String[]{"-t qatest_TopicTest", "-g qatest_consumer", "-s 1389098416742", "-f true"};
        CommandLine commandLine = ServerUtil.parseCmdLine((String)("mqadmin " + cmd.commandName()), (String[])subargs, (Options)cmd.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
        cmd.execute(commandLine, options, null);
    }
}

