/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.store.AppendMessageCallback;
import com.alibaba.rocketmq.store.AppendMessageResult;
import com.alibaba.rocketmq.store.AppendMessageStatus;
import com.alibaba.rocketmq.store.ReferenceResource;
import com.alibaba.rocketmq.store.SelectMapedBufferResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapedFile
extends ReferenceResource {
    public static final int OS_PAGE_SIZE = 4096;
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final AtomicLong TotalMapedVitualMemory = new AtomicLong(0L);
    private static final AtomicInteger TotalMapedFiles = new AtomicInteger(0);
    private final String fileName;
    private final long fileFromOffset;
    private final int fileSize;
    private final File file;
    private final MappedByteBuffer mappedByteBuffer;
    private final AtomicInteger wrotePostion = new AtomicInteger(0);
    private final AtomicInteger committedPosition = new AtomicInteger(0);
    private FileChannel fileChannel;
    private volatile long storeTimestamp = 0L;
    private boolean firstCreateInQueue = false;

    public MapedFile(String fileName, int fileSize) throws IOException {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.file = new File(fileName);
        this.fileFromOffset = Long.parseLong(this.file.getName());
        boolean ok = false;
        MapedFile.ensureDirOK(this.file.getParent());
        try {
            this.fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
            TotalMapedVitualMemory.addAndGet(fileSize);
            TotalMapedFiles.incrementAndGet();
            ok = true;
        }
        catch (FileNotFoundException e) {
            log.error("create file channel " + this.fileName + " Failed. ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error("map file " + this.fileName + " Failed. ", (Throwable)e);
            throw e;
        }
        finally {
            if (!ok && this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
    }

    public static void ensureDirOK(String dirName) {
        File f;
        if (dirName != null && !(f = new File(dirName)).exists()) {
            boolean result = f.mkdirs();
            log.info(dirName + " mkdir " + (result ? "OK" : "Failed"));
        }
    }

    public static void clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect() || buffer.capacity() == 0) {
            return;
        }
        MapedFile.invoke(MapedFile.invoke(MapedFile.viewed(buffer), "cleaner", new Class[0]), "clean", new Class[0]);
    }

    private static Object invoke(final Object target, final String methodName, final Class<?> ... args) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = MapedFile.method(target, methodName, args);
                    method.setAccessible(true);
                    return method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private static Method method(Object target, String methodName, Class<?>[] args) throws NoSuchMethodException {
        try {
            return target.getClass().getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            return target.getClass().getDeclaredMethod(methodName, args);
        }
    }

    private static ByteBuffer viewed(ByteBuffer buffer) {
        ByteBuffer viewedBuffer;
        String methodName = "viewedBuffer";
        Method[] methods = buffer.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("attachment")) continue;
            methodName = "attachment";
            break;
        }
        if ((viewedBuffer = (ByteBuffer)MapedFile.invoke(buffer, methodName, new Class[0])) == null) {
            return buffer;
        }
        return MapedFile.viewed(viewedBuffer);
    }

    public static int getTotalmapedfiles() {
        return TotalMapedFiles.get();
    }

    public static long getTotalMapedVitualMemory() {
        return TotalMapedVitualMemory.get();
    }

    public long getLastModifiedTimestamp() {
        return this.file.lastModified();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public AppendMessageResult appendMessage(Object msg, AppendMessageCallback cb) {
        assert (msg != null);
        assert (cb != null);
        int currentPos = this.wrotePostion.get();
        if (currentPos < this.fileSize) {
            ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
            byteBuffer.position(currentPos);
            AppendMessageResult result = cb.doAppend(this.getFileFromOffset(), byteBuffer, this.fileSize - currentPos, msg);
            this.wrotePostion.addAndGet(result.getWroteBytes());
            this.storeTimestamp = result.getStoreTimestamp();
            return result;
        }
        log.error("MapedFile.appendMessage return null, wrotePostion: " + currentPos + " fileSize: " + this.fileSize);
        return new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR);
    }

    public long getFileFromOffset() {
        return this.fileFromOffset;
    }

    public boolean appendMessage(byte[] data) {
        int currentPos = this.wrotePostion.get();
        if (currentPos + data.length <= this.fileSize) {
            ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
            byteBuffer.position(currentPos);
            byteBuffer.put(data);
            this.wrotePostion.addAndGet(data.length);
            return true;
        }
        return false;
    }

    public int commit(int flushLeastPages) {
        if (this.isAbleToFlush(flushLeastPages)) {
            if (this.hold()) {
                int value = this.wrotePostion.get();
                this.mappedByteBuffer.force();
                this.committedPosition.set(value);
                this.release();
            } else {
                log.warn("in commit, hold failed, commit offset = " + this.committedPosition.get());
                this.committedPosition.set(this.wrotePostion.get());
            }
        }
        return this.getCommittedPosition();
    }

    public int getCommittedPosition() {
        return this.committedPosition.get();
    }

    public void setCommittedPosition(int pos) {
        this.committedPosition.set(pos);
    }

    private boolean isAbleToFlush(int flushLeastPages) {
        int flush = this.committedPosition.get();
        int write = this.wrotePostion.get();
        if (this.isFull()) {
            return true;
        }
        if (flushLeastPages > 0) {
            return write / 4096 - flush / 4096 >= flushLeastPages;
        }
        return write > flush;
    }

    public boolean isFull() {
        return this.fileSize == this.wrotePostion.get();
    }

    public SelectMapedBufferResult selectMapedBuffer(int pos, int size) {
        if (pos + size <= this.wrotePostion.get()) {
            if (this.hold()) {
                ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
                byteBuffer.position(pos);
                ByteBuffer byteBufferNew = byteBuffer.slice();
                byteBufferNew.limit(size);
                return new SelectMapedBufferResult(this.fileFromOffset + (long)pos, byteBufferNew, size, this);
            }
            log.warn("matched, but hold failed, request pos: " + pos + ", fileFromOffset: " + this.fileFromOffset);
        } else {
            log.warn("selectMapedBuffer request pos invalid, request pos: " + pos + ", size: " + size + ", fileFromOffset: " + this.fileFromOffset);
        }
        return null;
    }

    public SelectMapedBufferResult selectMapedBuffer(int pos) {
        if (pos < this.wrotePostion.get() && pos >= 0 && this.hold()) {
            ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
            byteBuffer.position(pos);
            int size = this.wrotePostion.get() - pos;
            ByteBuffer byteBufferNew = byteBuffer.slice();
            byteBufferNew.limit(size);
            return new SelectMapedBufferResult(this.fileFromOffset + (long)pos, byteBufferNew, size, this);
        }
        return null;
    }

    @Override
    public boolean cleanup(long currentRef) {
        if (this.isAvailable()) {
            log.error("this file[REF:" + currentRef + "] " + this.fileName + " have not shutdown, stop unmaping.");
            return false;
        }
        if (this.isCleanupOver()) {
            log.error("this file[REF:" + currentRef + "] " + this.fileName + " have cleanup, do not do it again.");
            return true;
        }
        MapedFile.clean(this.mappedByteBuffer);
        TotalMapedVitualMemory.addAndGet(this.fileSize * -1);
        TotalMapedFiles.decrementAndGet();
        log.info("unmap file[REF:" + currentRef + "] " + this.fileName + " OK");
        return true;
    }

    public boolean destroy(long intervalForcibly) {
        this.shutdown(intervalForcibly);
        if (this.isCleanupOver()) {
            try {
                this.fileChannel.close();
                log.info("close file channel " + this.fileName + " OK");
                long beginTime = System.currentTimeMillis();
                boolean result = this.file.delete();
                log.info("delete file[REF:" + this.getRefCount() + "] " + this.fileName + (result ? " OK, " : " Failed, ") + "W:" + this.getWrotePostion() + " M:" + this.getCommittedPosition() + ", " + UtilAll.computeEclipseTimeMilliseconds((long)beginTime));
            }
            catch (Exception e) {
                log.warn("close file channel " + this.fileName + " Failed. ", (Throwable)e);
            }
            return true;
        }
        log.warn("destroy maped file[REF:" + this.getRefCount() + "] " + this.fileName + " Failed. cleanupOver: " + this.cleanupOver);
        return false;
    }

    public int getWrotePostion() {
        return this.wrotePostion.get();
    }

    public void setWrotePostion(int pos) {
        this.wrotePostion.set(pos);
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    public ByteBuffer sliceByteBuffer() {
        return this.mappedByteBuffer.slice();
    }

    public long getStoreTimestamp() {
        return this.storeTimestamp;
    }

    public boolean isFirstCreateInQueue() {
        return this.firstCreateInQueue;
    }

    public void setFirstCreateInQueue(boolean firstCreateInQueue) {
        this.firstCreateInQueue = firstCreateInQueue;
    }
}

