/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.remoting.netty;

import com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDecoder
extends LengthFieldBasedFrameDecoder {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final int FRAME_MAX_LENGTH = 0x800000;

    public NettyDecoder() {
        super(0x800000, 0, 4, 0, 4);
    }

    public Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        try {
            ByteBuf frame = (ByteBuf)super.decode(ctx, in);
            if (frame == null) {
                return null;
            }
            byte[] tmpBuf = new byte[frame.capacity()];
            frame.getBytes(0, tmpBuf);
            frame.release();
            return RemotingCommand.decode(tmpBuf);
        }
        catch (Exception e) {
            log.error("decode exception, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel()), (Throwable)e);
            RemotingUtil.closeChannel(ctx.channel());
            return null;
        }
    }
}

