/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.remoting.common;

import com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.alibaba.rocketmq.shade.io.netty.channel.Channel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class RemotingHelper {
    public static final String RemotingLogName = "RocketmqRemoting";

    public static String exceptionSimpleDesc(Throwable e) {
        StringBuffer sb = new StringBuffer();
        if (e != null) {
            sb.append(e.toString());
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                StackTraceElement elment = stackTrace[0];
                sb.append(", ");
                sb.append(elment.toString());
            }
        }
        return sb.toString();
    }

    public static SocketAddress string2SocketAddress(String addr) {
        String[] s = addr.split(":");
        InetSocketAddress isa = new InetSocketAddress(s[0], (int)Integer.valueOf(s[1]));
        return isa;
    }

    public static RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        long beginTime = System.currentTimeMillis();
        SocketAddress socketAddress = RemotingUtil.string2SocketAddress(addr);
        SocketChannel socketChannel = RemotingUtil.connect(socketAddress);
        if (socketChannel != null) {
            boolean sendRequestOK = false;
            try {
                socketChannel.configureBlocking(true);
                socketChannel.socket().setSoTimeout((int)timeoutMillis);
                ByteBuffer byteBufferRequest = request.encode();
                while (byteBufferRequest.hasRemaining()) {
                    int length = socketChannel.write(byteBufferRequest);
                    if (length > 0) {
                        if (byteBufferRequest.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingSendRequestException(addr);
                        }
                    } else {
                        throw new RemotingSendRequestException(addr);
                    }
                    Thread.sleep(1L);
                }
                sendRequestOK = true;
                ByteBuffer byteBufferSize = ByteBuffer.allocate(4);
                while (byteBufferSize.hasRemaining()) {
                    int length = socketChannel.read(byteBufferSize);
                    if (length > 0) {
                        if (byteBufferSize.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingTimeoutException(addr, timeoutMillis);
                        }
                    } else {
                        throw new RemotingTimeoutException(addr, timeoutMillis);
                    }
                    Thread.sleep(1L);
                }
                int size = byteBufferSize.getInt(0);
                ByteBuffer byteBufferBody = ByteBuffer.allocate(size);
                while (byteBufferBody.hasRemaining()) {
                    int length = socketChannel.read(byteBufferBody);
                    if (length > 0) {
                        if (byteBufferBody.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingTimeoutException(addr, timeoutMillis);
                        }
                    } else {
                        throw new RemotingTimeoutException(addr, timeoutMillis);
                    }
                    Thread.sleep(1L);
                }
                byteBufferBody.flip();
                RemotingCommand remotingCommand = RemotingCommand.decode(byteBufferBody);
                return remotingCommand;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (sendRequestOK) {
                    throw new RemotingTimeoutException(addr, timeoutMillis);
                }
                throw new RemotingSendRequestException(addr);
            }
            finally {
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        throw new RemotingConnectException(addr);
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        String addr;
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseChannelRemoteName(Channel channel) {
        if (null == channel) {
            return "";
        }
        InetSocketAddress remote = (InetSocketAddress)channel.remoteAddress();
        if (remote != null) {
            return remote.getAddress().getHostName();
        }
        return "";
    }

    public static String parseSocketAddressAddr(SocketAddress socketAddress) {
        String addr;
        if (socketAddress != null && (addr = socketAddress.toString()).length() > 0) {
            return addr.substring(1);
        }
        return "";
    }

    public static String parseSocketAddressName(SocketAddress socketAddress) {
        InetSocketAddress addrs = (InetSocketAddress)socketAddress;
        if (addrs != null) {
            return addrs.getAddress().getHostName();
        }
        return "";
    }
}

