/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.stat;

import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.client.stat.ConsumerStat;
import java.util.LinkedList;
import org.slf4j.Logger;

public class ConsumerStatManager {
    private final Logger log = ClientLogger.getLog();
    private final ConsumerStat consumertat = new ConsumerStat();
    private final LinkedList<ConsumerStat> snapshotList = new LinkedList();

    public ConsumerStat getConsumertat() {
        return this.consumertat;
    }

    public LinkedList<ConsumerStat> getSnapshotList() {
        return this.snapshotList;
    }

    public void recordSnapshotPeriodically() {
        this.snapshotList.addLast(this.consumertat.createSnapshot());
        if (this.snapshotList.size() > 60) {
            this.snapshotList.removeFirst();
        }
    }

    public void logStatsPeriodically(String group, String clientId) {
        if (this.snapshotList.size() >= 60) {
            ConsumerStat first = this.snapshotList.getFirst();
            ConsumerStat last = this.snapshotList.getLast();
            double avgRT = (double)(last.getConsumeMsgRTTotal().get() - first.getConsumeMsgRTTotal().get()) / (double)(last.getConsumeMsgOKTotal().get() + last.getConsumeMsgFailedTotal().get() - (first.getConsumeMsgOKTotal().get() + first.getConsumeMsgFailedTotal().get()));
            double tps = (double)(last.getConsumeMsgOKTotal().get() + last.getConsumeMsgFailedTotal().get() - (first.getConsumeMsgOKTotal().get() + first.getConsumeMsgFailedTotal().get())) / (double)(last.getCreateTimestamp() - first.getCreateTimestamp());
            this.log.info("Consumer, {} {}, ConsumeAvgRT(ms): {} ConsumeMaxRT(ms): {} TotalOKMsg: {} TotalFailedMsg: {} consumeTPS: {}", new Object[]{group, clientId, avgRT, last.getConsumeMsgRTMax(), last.getConsumeMsgOKTotal(), last.getConsumeMsgFailedTotal(), tps *= 1000.0});
            avgRT = (double)(last.getPullRTTotal().get() - first.getPullRTTotal().get()) / (double)(last.getPullTimesTotal().get() - first.getPullTimesTotal().get());
            this.log.info("Consumer, {} {}, PullAvgRT(ms): {}  PullTimesTotal: {}", new Object[]{group, clientId, avgRT, last.getPullTimesTotal()});
        }
    }
}

