/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl;

import com.alibaba.rocketmq.client.QueryResult;
import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.impl.factory.MQClientFactory;
import com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.common.TopicConfig;
import com.alibaba.rocketmq.common.help.FAQUrl;
import com.alibaba.rocketmq.common.message.MessageDecoder;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.message.MessageId;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.common.protocol.header.QueryMessageRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryMessageResponseHeader;
import com.alibaba.rocketmq.common.protocol.route.BrokerData;
import com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.alibaba.rocketmq.remoting.InvokeCallback;
import com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.alibaba.rocketmq.remoting.netty.ResponseFuture;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class MQAdminImpl {
    private final Logger log = ClientLogger.getLog();
    private final MQClientFactory mQClientFactory;

    public MQAdminImpl(MQClientFactory mQClientFactory) {
        this.mQClientFactory = mQClientFactory;
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        block7: {
            try {
                TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(key, 3000L);
                List brokerDataList = topicRouteData.getBrokerDatas();
                if (brokerDataList != null && !brokerDataList.isEmpty()) {
                    Collections.sort(brokerDataList);
                    MQClientException exception = null;
                    StringBuilder orderTopicString = new StringBuilder();
                    for (BrokerData brokerData : brokerDataList) {
                        String addr = (String)brokerData.getBrokerAddrs().get(0L);
                        if (addr == null) continue;
                        TopicConfig topicConfig = new TopicConfig(newTopic);
                        topicConfig.setReadQueueNums(queueNum);
                        topicConfig.setWriteQueueNums(queueNum);
                        try {
                            this.mQClientFactory.getMQClientAPIImpl().createTopic(addr, key, topicConfig, 3000L);
                        }
                        catch (Exception e) {
                            exception = new MQClientException("create topic to broker exception", e);
                        }
                        orderTopicString.append(brokerData.getBrokerName());
                        orderTopicString.append(":");
                        orderTopicString.append(queueNum);
                        orderTopicString.append(";");
                    }
                    if (exception != null) {
                        throw exception;
                    }
                    break block7;
                }
                throw new MQClientException("Not found broker, maybe key is wrong", null);
            }
            catch (Exception e) {
                throw new MQClientException("create new topic failed", e);
            }
        }
    }

    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        try {
            TopicPublishInfo topicPublishInfo;
            TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, 3000L);
            if (topicRouteData != null && (topicPublishInfo = MQClientFactory.topicRouteData2TopicPublishInfo(topic, topicRouteData)) != null && topicPublishInfo.ok()) {
                return topicPublishInfo.getMessageQueueList();
            }
        }
        catch (Exception e) {
            throw new MQClientException("Can not find Message Queue for this topic, " + topic, e);
        }
        throw new MQClientException("Unknow why, Can not find Message Queue for this topic, " + topic, null);
    }

    public Set<MessageQueue> fetchSubscribeMessageQueues(String topic) throws MQClientException {
        try {
            TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, 3000L);
            if (topicRouteData != null) {
                Set<MessageQueue> mqList = MQClientFactory.topicRouteData2TopicSubscribeInfo(topic, topicRouteData);
                if (!mqList.isEmpty()) {
                    return mqList;
                }
                throw new MQClientException("Can not find Message Queue for this topic, " + topic + " Namesrv return empty", null);
            }
        }
        catch (Exception e) {
            throw new MQClientException("Can not find Message Queue for this topic, " + topic + FAQUrl.suggestTodo((String)"https://github.com/alibaba/RocketMQ/issues/336"), e);
        }
        throw new MQClientException("Unknow why, Can not find Message Queue for this topic, " + topic, null);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().searchOffset(brokerAddr, mq.getTopic(), mq.getQueueId(), timestamp, 3000L);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getMaxOffset(brokerAddr, mq.getTopic(), mq.getQueueId(), 3000L);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getMinOffset(brokerAddr, mq.getTopic(), mq.getQueueId(), 3000L);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getEarliestMsgStoretime(brokerAddr, mq.getTopic(), mq.getQueueId(), 3000L);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public MessageExt viewMessage(String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            MessageId messageId = MessageDecoder.decodeMessageId((String)msgId);
            return this.mQClientFactory.getMQClientAPIImpl().viewMessage(RemotingUtil.socketAddress2String((SocketAddress)messageId.getAddress()), messageId.getOffset(), 3000L);
        }
        catch (UnknownHostException e) {
            throw new MQClientException("message id illegal", e);
        }
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        TopicRouteData topicRouteData = this.mQClientFactory.getAnExistTopicRouteData(topic);
        if (null == topicRouteData) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic);
            topicRouteData = this.mQClientFactory.getAnExistTopicRouteData(topic);
        }
        if (topicRouteData != null) {
            LinkedList<String> brokerAddrs = new LinkedList<String>();
            for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
                String addr = brokerData.selectBrokerAddr();
                if (addr == null) continue;
                brokerAddrs.add(addr);
            }
            if (!brokerAddrs.isEmpty()) {
                final CountDownLatch countDownLatch = new CountDownLatch(brokerAddrs.size());
                final LinkedList queryResultList = new LinkedList();
                for (String addr : brokerAddrs) {
                    try {
                        QueryMessageRequestHeader requestHeader = new QueryMessageRequestHeader();
                        requestHeader.setTopic(topic);
                        requestHeader.setKey(key);
                        requestHeader.setMaxNum(Integer.valueOf(maxNum));
                        requestHeader.setBeginTimestamp(Long.valueOf(begin));
                        requestHeader.setEndTimestamp(Long.valueOf(end));
                        this.mQClientFactory.getMQClientAPIImpl().queryMessage(addr, requestHeader, 5000L, new InvokeCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(ResponseFuture responseFuture) {
                                block10: {
                                    try {
                                        RemotingCommand response = responseFuture.getResponseCommand();
                                        if (response != null) {
                                            switch (response.getCode()) {
                                                case 0: {
                                                    QueryMessageResponseHeader responseHeader = null;
                                                    try {
                                                        responseHeader = (QueryMessageResponseHeader)response.decodeCommandCustomHeader(QueryMessageResponseHeader.class);
                                                    }
                                                    catch (RemotingCommandException e) {
                                                        MQAdminImpl.this.log.error("decodeCommandCustomHeader exception", (Throwable)e);
                                                        countDownLatch.countDown();
                                                        return;
                                                    }
                                                    List wrappers = MessageDecoder.decodes((ByteBuffer)ByteBuffer.wrap(response.getBody()), (boolean)true);
                                                    QueryResult qr = new QueryResult(responseHeader.getIndexLastUpdateTimestamp(), wrappers);
                                                    queryResultList.add(qr);
                                                    break;
                                                }
                                                default: {
                                                    MQAdminImpl.this.log.warn("getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                                                    break;
                                                }
                                            }
                                            break block10;
                                        }
                                        MQAdminImpl.this.log.warn("getResponseCommand return null");
                                    }
                                    finally {
                                        countDownLatch.countDown();
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        this.log.warn("queryMessage exception", (Throwable)e);
                    }
                }
                boolean ok = countDownLatch.await(10000L, TimeUnit.MILLISECONDS);
                if (!ok) {
                    this.log.warn("queryMessage, maybe some broker failed");
                }
                long indexLastUpdateTimestamp = 0L;
                LinkedList<MessageExt> messageList = new LinkedList<MessageExt>();
                for (QueryResult qr : queryResultList) {
                    if (qr.getIndexLastUpdateTimestamp() > indexLastUpdateTimestamp) {
                        indexLastUpdateTimestamp = qr.getIndexLastUpdateTimestamp();
                    }
                    for (MessageExt msgExt : qr.getMessageList()) {
                        String keys = msgExt.getKeys();
                        if (keys == null) continue;
                        boolean matched = false;
                        String[] keyArray = keys.split(" ");
                        if (keyArray != null) {
                            for (String k : keyArray) {
                                if (!key.equals(k)) continue;
                                matched = true;
                                break;
                            }
                        }
                        if (matched) {
                            messageList.add(msgExt);
                            continue;
                        }
                        this.log.warn("queryMessage, client find not matched message {}", (Object)msgExt.toString());
                    }
                }
                if (!messageList.isEmpty()) {
                    return new QueryResult(indexLastUpdateTimestamp, messageList);
                }
                throw new MQClientException("query operation over, but no message.", null);
            }
        }
        throw new MQClientException("The topic[" + topic + "] not matched route info", null);
    }
}

