/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.http.HttpScheme;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.io.ssl.SslConnection;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.Connector;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.HttpConfiguration;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.Request;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.TypeUtil;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.log.Log;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.log.Logger;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.ssl.SslContextFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public class SecureRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final Logger LOG = Log.getLogger(SecureRequestCustomizer.class);
    public static final String CACHED_INFO_ATTR = CachedInfo.class.getName();

    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        if (request.getHttpChannel().getEndPoint() instanceof SslConnection.DecryptedEndPoint) {
            request.setScheme(HttpScheme.HTTPS.asString());
            request.setSecure(true);
            SslConnection.DecryptedEndPoint ssl_endp = (SslConnection.DecryptedEndPoint)request.getHttpChannel().getEndPoint();
            SslConnection sslConnection = ssl_endp.getSslConnection();
            SSLEngine sslEngine = sslConnection.getSSLEngine();
            this.customize(sslEngine, request);
        }
    }

    public void customize(SSLEngine sslEngine, Request request) {
        request.setScheme(HttpScheme.HTTPS.asString());
        SSLSession sslSession = sslEngine.getSession();
        try {
            String idStr;
            X509Certificate[] certs;
            Integer keySize;
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
                idStr = cachedInfo.getIdStr();
            } else {
                keySize = new Integer(SslContextFactory.deduceKeyLength(cipherSuite));
                certs = SslContextFactory.getCertChain(sslSession);
                byte[] bytes = sslSession.getId();
                idStr = TypeUtil.toHexString(bytes);
                cachedInfo = new CachedInfo(keySize, certs, idStr);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            }
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", keySize);
            request.setAttribute("javax.servlet.request.ssl_session_id", idStr);
        }
        catch (Exception e) {
            LOG.warn("EXCEPTION ", e);
        }
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    private static class CachedInfo {
        private final X509Certificate[] _certs;
        private final Integer _keySize;
        private final String _idStr;

        CachedInfo(Integer keySize, X509Certificate[] certs, String idStr) {
            this._keySize = keySize;
            this._certs = certs;
            this._idStr = idStr;
        }

        X509Certificate[] getCerts() {
            return this._certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        String getIdStr() {
            return this._idStr;
        }
    }
}

