/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.AbstractSqlType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;

public class ArraySqlType
extends AbstractSqlType {
    private final RelDataType elementType;

    public ArraySqlType(RelDataType elementType, boolean isNullable) {
        super(SqlTypeName.ARRAY, isNullable, null);
        this.elementType = Preconditions.checkNotNull(elementType);
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        if (withDetail) {
            sb.append(this.elementType.getFullTypeString());
        } else {
            sb.append(this.elementType.toString());
        }
        sb.append(" ARRAY");
    }

    @Override
    public RelDataType getComponentType() {
        return this.elementType;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new RelDataTypePrecedenceList(){

            @Override
            public boolean containsType(RelDataType type) {
                return type.getSqlTypeName() == ArraySqlType.this.getSqlTypeName() && type.getComponentType() != null && ArraySqlType.this.getComponentType().getPrecedenceList().containsType(type.getComponentType());
            }

            @Override
            public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
                if (!this.containsType(type1)) {
                    throw new IllegalArgumentException("must contain type: " + type1);
                }
                if (!this.containsType(type2)) {
                    throw new IllegalArgumentException("must contain type: " + type2);
                }
                return ArraySqlType.this.getComponentType().getPrecedenceList().compareTypePrecedence(type1.getComponentType(), type2.getComponentType());
            }
        };
    }
}

