/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunctionCategory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlCase;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.ReturnTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.List;

public class SqlCoalesceFunction
extends SqlFunction {
    public SqlCoalesceFunction() {
        super("COALESCE", SqlKind.COALESCE, ReturnTypes.LEAST_RESTRICTIVE, null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        this.validateQuantifier(validator, call);
        List<SqlNode> operands = call.getOperandList();
        if (operands.size() == 1) {
            return operands.get(0);
        }
        SqlParserPos pos = call.getParserPosition();
        SqlNodeList whenList = new SqlNodeList(pos);
        SqlNodeList thenList = new SqlNodeList(pos);
        for (SqlNode operand : Util.skipLast(operands)) {
            whenList.add(SqlStdOperatorTable.IS_NOT_NULL.createCall(pos, operand));
            thenList.add(SqlNode.clone(operand));
        }
        SqlNode elseExpr = Util.last(operands);
        assert (call.getFunctionQuantifier() == null);
        return SqlCase.createSwitched(pos, null, whenList, thenList, elseExpr);
    }
}

