/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Ord;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.StructKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import java.io.Serializable;
import java.util.List;

public class RelRecordType
extends RelDataTypeImpl
implements Serializable {
    private final StructKind kind;

    public RelRecordType(StructKind kind, List<RelDataTypeField> fields) {
        super(fields);
        this.kind = Preconditions.checkNotNull(kind);
        this.computeDigest();
    }

    public RelRecordType(List<RelDataTypeField> fields) {
        this(StructKind.FULLY_QUALIFIED, fields);
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return SqlTypeName.ROW;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public StructKind getStructKind() {
        return this.kind;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("RecordType");
        switch (this.kind) {
            case PEEK_FIELDS: {
                sb.append(":peek");
                break;
            }
            case PEEK_FIELDS_DEFAULT: {
                sb.append(":peek_default");
                break;
            }
            case PEEK_FIELDS_NO_EXPAND: {
                sb.append(":peek_no_expand");
            }
        }
        sb.append("(");
        for (Ord ord : Ord.zip(this.fieldList)) {
            if (ord.i > 0) {
                sb.append(", ");
            }
            RelDataTypeField field = (RelDataTypeField)ord.e;
            if (withDetail) {
                sb.append(field.getType().getFullTypeString());
            } else {
                sb.append(field.getType().toString());
            }
            sb.append(" ");
            sb.append(field.getName());
        }
        sb.append(")");
    }

    private Object writeReplace() {
        return new SerializableRelRecordType(this.fieldList);
    }

    private static class SerializableRelRecordType
    implements Serializable {
        private List<RelDataTypeField> fields;

        private SerializableRelRecordType(List<RelDataTypeField> fields) {
            this.fields = fields;
        }

        private Object readResolve() {
            return new RelRecordType(this.fields);
        }
    }
}

