/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Aggregate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Filter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Project;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.SemiJoin;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Sort;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Union;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.MetadataDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.MetadataHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BuiltInMethod;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;

public class RelMdSelectivity
implements MetadataHandler<BuiltInMetadata.Selectivity> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.SELECTIVITY.method, new RelMdSelectivity());

    protected RelMdSelectivity() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Selectivity> getDef() {
        return BuiltInMetadata.Selectivity.DEF;
    }

    public Double getSelectivity(Union rel, RelMetadataQuery mq, RexNode predicate) {
        if (rel.getInputs().size() == 0 || predicate == null) {
            return 1.0;
        }
        double sumRows = 0.0;
        double sumSelectedRows = 0.0;
        int[] adjustments = new int[rel.getRowType().getFieldCount()];
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (RelNode input : rel.getInputs()) {
            Double nRows = mq.getRowCount(input);
            if (nRows == null) {
                return null;
            }
            RexNode modifiedPred = predicate.accept(new RelOptUtil.RexInputConverter(rexBuilder, null, input.getRowType().getFieldList(), adjustments));
            double sel = mq.getSelectivity(input, modifiedPred);
            sumRows += nRows.doubleValue();
            sumSelectedRows += nRows * sel;
        }
        if (sumRows < 1.0) {
            sumRows = 1.0;
        }
        return sumSelectedRows / sumRows;
    }

    public Double getSelectivity(Sort rel, RelMetadataQuery mq, RexNode predicate) {
        return mq.getSelectivity(rel.getInput(), predicate);
    }

    public Double getSelectivity(Filter rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds(rel.getCluster().getRexBuilder(), predicate, rel.getCondition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.getCondition());
    }

    public Double getSelectivity(SemiJoin rel, RelMetadataQuery mq, RexNode predicate) {
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode newPred = RelMdUtil.makeSemiJoinSelectivityRexNode(mq, rel);
        if (predicate != null) {
            newPred = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newPred, predicate);
        }
        return mq.getSelectivity(rel.getLeft(), newPred);
    }

    public Double getSelectivity(Aggregate rel, RelMetadataQuery mq, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(rel.getGroupSet(), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        Double selectivity = mq.getSelectivity(rel.getInput(), childPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(Project rel, RelMetadataQuery mq, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(rel.getRowType().getFieldCount()), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        RexNode modifiedPred = childPred == null ? null : RelOptUtil.pushPastProject(childPred, rel);
        Double selectivity = mq.getSelectivity(rel.getInput(), modifiedPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(RelNode rel, RelMetadataQuery mq, RexNode predicate) {
        return RelMdUtil.guessSelectivity(predicate);
    }
}

