/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.DeclarationStatement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Evaluator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.ExpressionType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expressions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Shuttle;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Statement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Visitor;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class BlockStatement
extends Statement {
    public final List<Statement> statements;
    private int hash;

    BlockStatement(List<Statement> statements, Type type) {
        super(ExpressionType.Block, type);
        assert (statements != null) : "statements should not be null";
        this.statements = statements;
        assert (this.distinctVariables(true));
    }

    private boolean distinctVariables(boolean fail) {
        HashSet<String> names = new HashSet<String>();
        for (Statement statement : this.statements) {
            String name;
            if (!(statement instanceof DeclarationStatement) || names.add(name = ((DeclarationStatement)statement).parameter.name)) continue;
            assert (!fail) : "duplicate variable " + name;
            return false;
        }
        return true;
    }

    @Override
    public BlockStatement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        List<Statement> newStatements = Expressions.acceptStatements(this.statements, shuttle);
        return shuttle.visit(this, newStatements);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        if (this.statements.isEmpty()) {
            writer.append("{}");
            return;
        }
        writer.begin("{\n");
        for (Statement node : this.statements) {
            node.accept(writer, 0, 0);
        }
        writer.end("}\n");
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        Object o = null;
        for (Statement statement : this.statements) {
            o = statement.evaluate(evaluator);
        }
        return o;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockStatement that = (BlockStatement)o;
        return this.statements.equals(that.statements);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, this.type, this.statements});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

