/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.MetricsSystem;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.MetricsSystemConfiguration;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.MetricsSystemFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.MetricsSystemLoader;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.noop.NoopMetricsSystemConfiguration;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.Driver;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.Service;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AvaticaHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AvaticaJsonHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AvaticaProtobufHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import com.alibaba.lindorm.thirdparty.org.slf4j.Logger;
import com.alibaba.lindorm.thirdparty.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.ServiceLoader;

public class HandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerFactory.class);

    public AvaticaHandler getHandler(Service service, Driver.Serialization serialization) {
        return this.getHandler(service, serialization, NoopMetricsSystemConfiguration.getInstance());
    }

    public AvaticaHandler getHandler(Service service, Driver.Serialization serialization, AvaticaServerConfiguration serverConfig) {
        return this.getHandler(service, serialization, NoopMetricsSystemConfiguration.getInstance(), serverConfig);
    }

    public AvaticaHandler getHandler(Service service, Driver.Serialization serialization, MetricsSystemConfiguration<?> metricsConfig) {
        return this.getHandler(service, serialization, metricsConfig, null);
    }

    public AvaticaHandler getHandler(Service service, Driver.Serialization serialization, MetricsSystemConfiguration<?> metricsConfig, AvaticaServerConfiguration serverConfig) {
        if (null == metricsConfig) {
            metricsConfig = NoopMetricsSystemConfiguration.getInstance();
        }
        MetricsSystem metrics = MetricsSystemLoader.load(metricsConfig);
        switch (serialization) {
            case JSON: {
                return new AvaticaJsonHandler(service, metrics, serverConfig);
            }
            case PROTOBUF: {
                return new AvaticaProtobufHandler(service, metrics, serverConfig);
            }
        }
        throw new IllegalArgumentException("Unknown Avatica handler for " + serialization.name());
    }

    MetricsSystem loadMetricsSystem(MetricsSystemConfiguration<?> config) {
        ServiceLoader<MetricsSystemFactory> loader = ServiceLoader.load(MetricsSystemFactory.class);
        ArrayList<MetricsSystemFactory> availableFactories = new ArrayList<MetricsSystemFactory>();
        for (MetricsSystemFactory factory : loader) {
            availableFactories.add(factory);
        }
        if (1 == availableFactories.size()) {
            MetricsSystemFactory factory = (MetricsSystemFactory)availableFactories.get(0);
            LOG.info("Loaded MetricsSystem {}", (Object)factory.getClass());
            return factory.create(config);
        }
        if (availableFactories.isEmpty()) {
            LOG.info("No metrics implementation available on classpath. Using No-op implementation");
            return NoopMetricsSystem.getInstance();
        }
        StringBuilder sb = new StringBuilder();
        for (MetricsSystemFactory factory : availableFactories) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(factory.getClass());
        }
        LOG.warn("Found multiple MetricsSystemFactory implementations: {}. Using No-op implementation", (Object)sb);
        return NoopMetricsSystem.getInstance();
    }
}

