/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.netty.jctools.queues;

import com.alibaba.lindorm.thirdparty.netty.jctools.queues.BaseSpscLinkedArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.CircularArrayOffsetCalculator;
import com.alibaba.lindorm.thirdparty.netty.jctools.util.Pow2;
import com.alibaba.lindorm.thirdparty.netty.jctools.util.UnsafeRefArrayAccess;

public class SpscUnboundedArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    public SpscUnboundedArrayQueue(int chunkSize) {
        int chunkCapacity = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        long mask = chunkCapacity - 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(chunkCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    protected boolean offerColdPath(E[] buffer, long mask, E e, long pIndex, long offset) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, e, pIndex, offset);
        } else if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, e, pIndex, offset);
        } else {
            E[] newBuffer = CircularArrayOffsetCalculator.allocate((int)(mask + 2L));
            this.producerBuffer = newBuffer;
            this.producerBufferLimit = pIndex + mask - 1L;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, e);
        }
        return true;
    }
}

