/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.netty.jctools.queues;

import com.alibaba.lindorm.thirdparty.netty.jctools.queues.MpmcArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.MpscArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.MpscCompoundQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.MpscLinkedQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.SpmcArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.SpscArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.SpscLinkedQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.spec.ConcurrentQueueSpec;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.spec.Ordering;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueueFactory {
    public static <E> Queue<E> newQueue(ConcurrentQueueSpec qs) {
        if (qs.isBounded()) {
            if (qs.isSpsc()) {
                return new SpscArrayQueue(qs.capacity);
            }
            if (qs.isMpsc()) {
                if (qs.ordering != Ordering.NONE) {
                    return new MpscArrayQueue(qs.capacity);
                }
                return new MpscCompoundQueue(qs.capacity);
            }
            if (qs.isSpmc()) {
                return new SpmcArrayQueue(qs.capacity);
            }
            return new MpmcArrayQueue(qs.capacity);
        }
        if (qs.isSpsc()) {
            return new SpscLinkedQueue();
        }
        if (qs.isMpsc()) {
            return MpscLinkedQueue.newMpscLinkedQueue();
        }
        return new ConcurrentLinkedQueue();
    }
}

