/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.Memory;
import com.alibaba.lindorm.thirdparty.com.yahoo.memory.NativeMemory;
import com.alibaba.lindorm.thirdparty.com.yahoo.memory.UnsafeUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Family;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.Util;
import java.nio.ByteOrder;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int FLAGS_BYTE = 3;
    static final int K_SHORT = 4;
    static final int N_LONG = 8;
    static final int MIN_DOUBLE = 16;
    static final int MAX_DOUBLE = 24;
    static final int COMBINED_BUFFER = 32;
    static final int BIG_ENDIAN_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    static final int DEFAULT_K = 128;

    private PreambleUtil() {
    }

    static String toString(byte[] byteArr, boolean isDoublesSketch) {
        NativeMemory mem = new NativeMemory(byteArr);
        return PreambleUtil.toString(mem, isDoublesSketch);
    }

    static String toString(Memory mem, boolean isDoublesSketch) {
        return PreambleUtil.memoryToString(mem, isDoublesSketch);
    }

    private static String memoryToString(Memory mem, boolean isDoublesSketch) {
        Object memObj = mem.array();
        long memAdd = mem.getCumulativeOffset(0L);
        int preLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
        int serVer = PreambleUtil.extractSerVer(memObj, memAdd);
        int familyID = PreambleUtil.extractFamilyID(memObj, memAdd);
        String famName = Family.idToFamily(familyID).toString();
        int flags = PreambleUtil.extractFlags(memObj, memAdd);
        boolean bigEndian = (flags & 1) > 0;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        boolean compact = (flags & 8) > 0;
        boolean ordered = (flags & 0x10) > 0;
        int k = PreambleUtil.extractK(memObj, memAdd);
        long n = preLongs == 1 ? 0L : PreambleUtil.extractN(memObj, memAdd);
        double minDouble = Double.POSITIVE_INFINITY;
        double maxDouble = Double.NEGATIVE_INFINITY;
        if (preLongs > 1 && isDoublesSketch) {
            minDouble = PreambleUtil.extractMinDouble(memObj, memAdd);
            maxDouble = PreambleUtil.extractMaxDouble(memObj, memAdd);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("### QUANTILES SKETCH PREAMBLE SUMMARY:").append(Util.LS);
        sb.append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS);
        sb.append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS);
        sb.append("Byte  2: Family               : ").append(famName).append(Util.LS);
        sb.append("Byte  3: Flags Field          : ").append(String.format("%02o", flags)).append(Util.LS);
        sb.append("  BIG ENDIAN                  : ").append(bigEndian).append(Util.LS);
        sb.append("  (Native Byte Order)         : ").append(nativeOrder).append(Util.LS);
        sb.append("  READ ONLY                   : ").append(readOnly).append(Util.LS);
        sb.append("  EMPTY                       : ").append(empty).append(Util.LS);
        sb.append("  COMPACT                     : ").append(compact).append(Util.LS);
        sb.append("  ORDERED                     : ").append(ordered).append(Util.LS);
        sb.append("Bytes  4-5  : K               : ").append(k).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
        }
        sb.append("Bytes  8-15 : N                : ").append(n).append(Util.LS);
        if (isDoublesSketch) {
            sb.append("MinDouble                      : ").append(minDouble).append(Util.LS);
            sb.append("MaxDouble                      : ").append(maxDouble).append(Util.LS);
        }
        sb.append("Retained Items                 : ").append(Util.computeRetainedItems(k, n)).append(Util.LS);
        sb.append("Total Bytes                    : ").append(mem.getCapacity()).append(Util.LS);
        sb.append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 0L) & 0xFF;
    }

    static int extractSerVer(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 1L) & 0xFF;
    }

    static int extractFamilyID(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 2L) & 0xFF;
    }

    static int extractFlags(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getByte(memObj, memAdd + 3L) & 0xFF;
    }

    static int extractK(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getShort(memObj, memAdd + 4L) & 0xFFFF;
    }

    static long extractN(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getLong(memObj, memAdd + 8L);
    }

    static double extractMinDouble(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getDouble(memObj, memAdd + 16L);
    }

    static double extractMaxDouble(Object memObj, long memAdd) {
        return UnsafeUtil.unsafe.getDouble(memObj, memAdd + 24L);
    }

    static void insertPreLongs(Object memObj, long memAdd, int value) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 0L, (byte)value);
    }

    static void insertSerVer(Object memObj, long memAdd, int value) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 1L, (byte)value);
    }

    static void insertFamilyID(Object memObj, long memAdd, int value) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 2L, (byte)value);
    }

    static void insertFlags(Object memObj, long memAdd, int value) {
        UnsafeUtil.unsafe.putByte(memObj, memAdd + 3L, (byte)value);
    }

    static void insertK(Object memObj, long memAdd, int value) {
        UnsafeUtil.unsafe.putShort(memObj, memAdd + 4L, (short)value);
    }

    static void insertN(Object memObj, long memAdd, long value) {
        UnsafeUtil.unsafe.putLong(memObj, memAdd + 8L, value);
    }

    static void insertMinDouble(Object memObj, long memAdd, double value) {
        UnsafeUtil.unsafe.putDouble(memObj, memAdd + 16L, value);
    }

    static void insertMaxDouble(Object memObj, long memAdd, double value) {
        UnsafeUtil.unsafe.putDouble(memObj, memAdd + 24L, value);
    }

    static void insertIntoBaseBuffer(Object memObj, long memAdd, int bbOffset, double value) {
        UnsafeUtil.unsafe.putDouble(memObj, memAdd + 32L + (long)bbOffset * 8L, value);
    }
}

