/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.BytesKeyAttributes;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ColumnFamilyDescriptor
extends VersionedObjectWithAttributes
implements Comparable<ColumnFamilyDescriptor> {
    private byte[] familyName;
    private BytesKeyAttributes otherAttr = null;
    private FamilyAttributes familyAttributes = new FamilyAttributes();

    public ColumnFamilyDescriptor() {
    }

    public ColumnFamilyDescriptor(byte[] familyName) {
        this.setName(familyName);
    }

    public ColumnFamilyDescriptor(String familyName) {
        this.setName(familyName);
    }

    public byte[] getName() {
        return this.familyName;
    }

    public ColumnFamilyDescriptor setName(String name) {
        return this.setName(Bytes.toBytes(name));
    }

    public ColumnFamilyDescriptor setName(byte[] name) {
        if (name == null || name.length <= 0) {
            throw new IllegalArgumentException("Family name must not be null or empty.");
        }
        this.familyName = name;
        return this;
    }

    public String getNameAsString() {
        return Bytes.toString(this.familyName);
    }

    public ColumnFamilyDescriptor setTimeToLive(int ttl, TimeUnit unit) {
        int seconds = (int)unit.toSeconds(ttl);
        this.familyAttributes.setTimeToLive(seconds);
        return this;
    }

    public int getTimeToLive() {
        return this.familyAttributes.getTimeToLive();
    }

    public ColumnFamilyDescriptor setCompression(String compression) {
        this.familyAttributes.setCompression(compression);
        return this;
    }

    public ColumnFamilyDescriptor setCompactionCompressionLevel(short level) {
        this.familyAttributes.setCompactionCompressionLevel(level);
        return this;
    }

    public short getCompactionCompressionLevel() {
        return this.familyAttributes.getCompactionCompressionLevel();
    }

    public String getCompression() {
        return this.familyAttributes.getCompression();
    }

    public ColumnFamilyDescriptor setDataBlockEncoding(String dataBlockEncoding) {
        this.familyAttributes.setDataBlockEncoding(dataBlockEncoding);
        return this;
    }

    public String getDataBlockEncoding() {
        return this.familyAttributes.getDataBlockEncoding();
    }

    public ColumnFamilyDescriptor setMaxVersions(int maxVersions) {
        this.familyAttributes.setMaxVersions(maxVersions);
        return this;
    }

    public int getMaxVersions() {
        return this.familyAttributes.getMaxVersions();
    }

    public ColumnFamilyDescriptor setMinVersions(int minVersions) {
        this.familyAttributes.setMinVersions(minVersions);
        return this;
    }

    public int getMinVersions() {
        return this.familyAttributes.getMinVersions();
    }

    public ColumnFamilyDescriptor setBloomFilterType(String bloomFilter) {
        this.familyAttributes.setBloomFilterType(bloomFilter);
        return this;
    }

    public String getBloomFilterType() {
        return this.familyAttributes.getBloomFilterType();
    }

    public ColumnFamilyDescriptor setMemStoreFilterType(String type) {
        this.familyAttributes.setMemStoreFilterType(type);
        return this;
    }

    public String getMemstoreFilterType() {
        return this.familyAttributes.getMemstoreFilterType();
    }

    public ColumnFamilyDescriptor setDfsReplication(short dfsReplication) {
        this.familyAttributes.setDfsReplication(dfsReplication);
        return this;
    }

    public short getDfsReplication() {
        return this.familyAttributes.getDfsReplication();
    }

    public ColumnFamilyDescriptor setStorageType(String storageType) {
        this.familyAttributes.setStorageType(storageType);
        return this;
    }

    public String getStorageType() {
        return this.familyAttributes.getStorageType();
    }

    public ColumnFamilyDescriptor setTimeToPurgeDeletes(long timeToPurgeDelete, TimeUnit unit) {
        long ms = unit.toMillis(timeToPurgeDelete);
        this.familyAttributes.setTimeToPurgeDeletes(ms);
        return this;
    }

    public long getTimeToPurgeDeletes() {
        return this.familyAttributes.getTimeToPurgeDeletes();
    }

    public ColumnFamilyDescriptor setInMemory(boolean inMemory) {
        this.familyAttributes.setInMemory(inMemory);
        return this;
    }

    public boolean isInMemory() {
        return this.familyAttributes.isInMemory();
    }

    public BytesKeyAttributes getOtherAttr() {
        return this.otherAttr;
    }

    public void setOtherAttr(ImmutableBytesPtr key, ImmutableBytesPtr value) {
        if (this.otherAttr == null) {
            this.otherAttr = new BytesKeyAttributes();
        }
        this.otherAttr.set(key, value);
    }

    public FamilyAttributes getFamilyAttributes() {
        return this.familyAttributes;
    }

    public void setFamilyAttributes(FamilyAttributes fa) {
        this.familyAttributes = fa;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[NAME => ");
        ret.append(Bytes.toString(this.familyName));
        ret.append(", ");
        ret.append(this.familyAttributes.toString());
        ret.append(", otherAttrF=");
        ret.append(this.otherAttr == null ? "_NA_" : this.otherAttr.toString());
        ret.append("]");
        return ret.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ColumnFamilyDescriptor)) {
            return false;
        }
        ColumnFamilyDescriptor other = (ColumnFamilyDescriptor)obj;
        if (!this.familyAttributes.equals(other.familyAttributes)) {
            return false;
        }
        return this.equalsAttributes(other);
    }

    @Override
    public int compareTo(ColumnFamilyDescriptor other) {
        Preconditions.checkNotNull(other);
        return Bytes.compareTo(this.familyName, other.familyName);
    }

    private void initFromAttributes() throws LindormException {
        try {
            byte[] otherAttrBytes = this.getAttribute("OTHER_ATTR");
            if (otherAttrBytes != null) {
                this.otherAttr = new BytesKeyAttributes();
                LindormObjectUtils.getWritable(otherAttrBytes, this.otherAttr);
                this.removeAttribute("OTHER_ATTR");
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void setupAttributes() throws LindormException {
        try {
            if (this.otherAttr != null) {
                this.setAttribute("OTHER_ATTR", LindormObjectUtils.getBytes(this.otherAttr));
            } else {
                this.removeAttribute("OTHER_ATTR");
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        Bytes.writeByteArray(out, this.familyName);
        this.familyAttributes.writeTo(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.familyName = Bytes.readByteArray(in);
        this.familyAttributes.readFrom(in);
        this.initFromAttributes();
    }
}

