/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.quota;

public enum QuotaLevel {
    USER("u", 1),
    NAMESPACE("n", 2),
    TABLE("t", 3),
    LOCAL("l", 4);

    private String name;
    private byte code;

    private QuotaLevel(String shortName, byte code) {
        this.name = shortName;
        this.code = code;
    }

    public String shortName() {
        return this.name;
    }

    public byte getCode() {
        return this.code;
    }

    public static QuotaLevel parseFromShortName(String name) {
        if (name.equals(USER.shortName())) {
            return USER;
        }
        if (name.equals(NAMESPACE.shortName())) {
            return NAMESPACE;
        }
        if (name.equals(TABLE.shortName())) {
            return TABLE;
        }
        if (name.equals(LOCAL.shortName())) {
            return LOCAL;
        }
        throw new IllegalArgumentException();
    }

    public static QuotaLevel parseFromByte(byte code) {
        switch (code) {
            case 1: {
                return USER;
            }
            case 2: {
                return NAMESPACE;
            }
            case 3: {
                return TABLE;
            }
            case 4: {
                return LOCAL;
            }
        }
        throw new IllegalArgumentException();
    }
}

