/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

public class ColumnBitmap {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    private long[] words;

    public ColumnBitmap(int numberOfBits) {
        this.words = new long[ColumnBitmap.wordIndex(numberOfBits - 1) + 1];
    }

    public ColumnBitmap(long[] words) {
        this.words = words;
    }

    public void set(int bitIndex) {
        int wordIndex;
        int n = wordIndex = ColumnBitmap.wordIndex(bitIndex);
        this.words[n] = this.words[n] | 1L << bitIndex;
    }

    public boolean get(int bitIndex) {
        int wordIndex = ColumnBitmap.wordIndex(bitIndex);
        return (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public void setFirstN(int numberOfBits) {
        long mask = -1L >>> 64 - numberOfBits;
        this.words[0] = this.words[0] | mask;
    }

    public boolean isClear() {
        for (long v : this.words) {
            if (v == 0L) continue;
            return false;
        }
        return true;
    }

    public ColumnBitmap and(ColumnBitmap other) {
        assert (this.words.length == other.words.length);
        long[] result = new long[this.words.length];
        for (int i = 0; i < this.words.length; ++i) {
            result[i] = this.words[i] & other.words[i];
        }
        return new ColumnBitmap(result);
    }

    public ColumnBitmap xor(ColumnBitmap other) {
        assert (this.words.length == other.words.length);
        long[] result = new long[this.words.length];
        for (int i = 0; i < this.words.length; ++i) {
            result[i] = this.words[i] ^ other.words[i];
        }
        return new ColumnBitmap(result);
    }

    public ColumnBitmap andXor(ColumnBitmap other) {
        assert (this.words.length == other.words.length);
        long[] result = new long[this.words.length];
        for (int i = 0; i < this.words.length; ++i) {
            result[i] = this.words[i] & other.words[i] ^ other.words[i];
        }
        return new ColumnBitmap(result);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnBitmap)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ColumnBitmap other = (ColumnBitmap)obj;
        assert (this.words.length == other.words.length);
        for (int i = 0; i < this.words.length; ++i) {
            if (this.words[i] == other.words[i]) continue;
            return false;
        }
        return true;
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }
}

