/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.command;

import com.alibaba.lindorm.client.core.command.Command;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CommandResult
extends VersionedObjectWithAttributes {
    private String result;
    private Command.Type type;
    private long commandID;
    private long startTime;
    private long endTime;

    public CommandResult() {
    }

    public CommandResult(String result, Command.Type type) {
        this.result = result;
        this.commandID = 0L;
        this.type = type;
        this.startTime = 0L;
        this.endTime = System.currentTimeMillis();
    }

    public CommandResult(String result, Command.Type type, long id) {
        this(result, type);
        this.commandID = id;
    }

    public CommandResult(String result, Command.Type type, long id, long startTime, long endTime) {
        this(result, type, id);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getResult() {
        return this.result;
    }

    public Command.Type getType() {
        return this.type;
    }

    public long getCommandID() {
        return this.commandID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.result);
        WritableUtils.writeVInt(out, this.type.getCode());
        WritableUtils.writeVLong(out, this.commandID);
        WritableUtils.writeVLong(out, this.startTime);
        WritableUtils.writeVLong(out, this.endTime);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.result = WritableUtils.readString(in);
        int code = WritableUtils.readVInt(in);
        this.type = Command.Type.codeToType(code);
        this.commandID = WritableUtils.readVLong(in);
        this.startTime = WritableUtils.readVLong(in);
        this.endTime = WritableUtils.readVLong(in);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("commandID= ").append(this.commandID).append(", type= ").append((Object)this.type).append(", result= ").append(this.result).append(", startTime= ").append(this.startTime).append(", endTime=").append(this.endTime).append("}");
        return builder.toString();
    }
}

