/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenamePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetComment;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTouch;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewRenameStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLCloseStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDescribeStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableSpaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLOpenStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLReleaseSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLReturnStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class SQLStatementParser
extends SQLParser {
    protected SQLExprParser exprParser;
    protected boolean parseCompleteValues = true;
    protected int parseValuesSize = 3;
    protected SQLSelectListCache selectListCache = null;

    public SQLStatementParser(String sql) {
        this(sql, null);
    }

    public SQLStatementParser(String sql, String dbType) {
        this(new SQLExprParser(sql, dbType));
    }

    public SQLStatementParser(SQLExprParser exprParser) {
        super(exprParser.getLexer(), exprParser.getDbType());
        this.exprParser = exprParser;
    }

    protected SQLStatementParser(Lexer lexer, String dbType) {
        super(lexer, dbType);
    }

    public boolean isKeepComments() {
        return this.lexer.isKeepComments();
    }

    public void setKeepComments(boolean keepComments) {
        this.lexer.setKeepComments(keepComments);
    }

    public SQLExprParser getExprParser() {
        return this.exprParser;
    }

    public List<SQLStatement> parseStatementList() {
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        this.parseStatementList(statementList, -1, null);
        return statementList;
    }

    public List<SQLStatement> parseStatementList(SQLObject parent) {
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        this.parseStatementList(statementList, -1, parent);
        return statementList;
    }

    public void parseStatementList(List<SQLStatement> statementList) {
        this.parseStatementList(statementList, -1, null);
    }

    public void parseStatementList(List<SQLStatement> statementList, int max) {
        this.parseStatementList(statementList, max, null);
    }

    public void parseStatementList(List<SQLStatement> statementList, int max, SQLObject parent) {
        if ("select @@session.tx_read_only".equals(this.lexer.text) && this.lexer.token == Token.SELECT) {
            SQLSelect select = new SQLSelect();
            MySqlSelectQueryBlock queryBlock = new MySqlSelectQueryBlock();
            queryBlock.addSelectItem(new SQLPropertyExpr(new SQLVariantRefExpr("@@session"), "tx_read_only"));
            select.setQuery(queryBlock);
            SQLSelectStatement stmt = new SQLSelectStatement(select);
            statementList.add(stmt);
            this.lexer.reset(29, '\u001a', Token.EOF);
            return;
        }
        block33: while (max == -1 || statementList.size() < max) {
            switch (this.lexer.token) {
                case EOF: 
                case END: 
                case UNTIL: 
                case ELSE: 
                case WHEN: {
                    if (this.lexer.isKeepComments() && this.lexer.hasComment() && statementList.size() > 0) {
                        SQLStatement stmt = statementList.get(statementList.size() - 1);
                        stmt.addAfterComment(this.lexer.readAndResetComments());
                    }
                    return;
                }
                case SEMI: {
                    int line0 = this.lexer.getLine();
                    this.lexer.nextToken();
                    int line1 = this.lexer.getLine();
                    if (statementList.size() <= 0) continue block33;
                    SQLStatement lastStmt = statementList.get(statementList.size() - 1);
                    lastStmt.setAfterSemi(true);
                    if (!this.lexer.isKeepComments()) continue block33;
                    SQLStatement stmt = statementList.get(statementList.size() - 1);
                    if (line1 - line0 > 1) continue block33;
                    stmt.addAfterComment(this.lexer.readAndResetComments());
                    continue block33;
                }
                case WITH: {
                    SQLStatement stmt = this.parseWith();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case SELECT: {
                    SQLStatement stmt = this.parseSelect();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case UPDATE: {
                    SQLUpdateStatement stmt = this.parseUpdateStatement();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case CREATE: {
                    SQLStatement stmt = this.parseCreate();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case INSERT: {
                    SQLStatement stmt = this.parseInsert();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case DELETE: {
                    SQLDeleteStatement stmt = this.parseDeleteStatement();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case EXPLAIN: {
                    SQLExplainStatement stmt = this.parseExplain();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case SET: {
                    SQLStatement stmt = this.parseSet();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case ALTER: {
                    SQLStatement stmt = this.parseAlter();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case TRUNCATE: {
                    SQLStatement stmt = this.parseTruncate();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case USE: {
                    SQLUseStatement stmt = this.parseUse();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case GRANT: {
                    SQLGrantStatement stmt = this.parseGrant();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case REVOKE: {
                    SQLRevokeStatement stmt = this.parseRevoke();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case SHOW: {
                    SQLStatement stmt = this.parseShow();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case MERGE: {
                    SQLStatement stmt = this.parseMerge();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case REPEAT: {
                    SQLStatement stmt = this.parseRepeat();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case DECLARE: {
                    SQLStatement stmt = this.parseDeclare();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case WHILE: {
                    SQLStatement stmt = this.parseWhile();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case IF: {
                    SQLStatement stmt = this.parseIf();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case CASE: {
                    SQLStatement stmt = this.parseCase();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case OPEN: {
                    SQLOpenStatement stmt = this.parseOpen();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case FETCH: {
                    SQLFetchStatement stmt = this.parseFetch();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case DROP: {
                    SQLStatement stmt = this.parseDrop();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case COMMENT: {
                    SQLCommentStatement stmt = this.parseComment();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case KILL: {
                    SQLStatement stmt = this.parseKill();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case CLOSE: {
                    SQLStatement stmt = this.parseClose();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case RETURN: {
                    SQLStatement stmt = this.parseReturn();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case UPSERT: {
                    SQLStatement stmt = this.parseUpsert();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
                case LEAVE: {
                    SQLStatement stmt = this.parseLeave();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    continue block33;
                }
            }
            if (this.lexer.token == Token.LBRACE || this.lexer.identifierEquals("CALL")) {
                SQLCallStatement stmt = this.parseCall();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.identifierEquals("UPSERT")) {
                SQLStatement stmt = this.parseUpsert();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.identifierEquals("RENAME")) {
                SQLStatement stmt = this.parseRename();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.identifierEquals("RELEASE")) {
                SQLStatement stmt = this.parseReleaseSavePoint();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.identifierEquals("SAVEPOINT")) {
                SQLStatement stmt = this.parseSavePoint();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.identifierEquals("ROLLBACK")) {
                SQLRollbackStatement stmt = this.parseRollback();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.identifierEquals("COMMIT")) {
                SQLStatement stmt = this.parseCommit();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.identifierEquals("RETURN")) {
                SQLStatement stmt = this.parseReturn();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token == Token.LPAREN) {
                char markChar = this.lexer.current();
                int markBp = this.lexer.bp();
                this.lexer.nextToken();
                if (this.lexer.token == Token.SELECT) {
                    this.lexer.reset(markBp, markChar, Token.LPAREN);
                    SQLStatement stmt = this.parseSelect();
                    statementList.add(stmt);
                    continue;
                }
            }
            int size = statementList.size();
            if (this.parseStatementListDialect(statementList)) {
                if (parent == null) continue;
                int i = size;
                while (true) {
                    if (i >= statementList.size()) continue block33;
                    SQLStatement dialectStmt = statementList.get(i);
                    dialectStmt.setParent(parent);
                    ++i;
                }
            }
            this.printError(this.lexer.token);
        }
        return;
    }

    public SQLStatement parseDrop() {
        SQLStatement stmt;
        List<String> beforeComments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            beforeComments = this.lexer.readAndResetComments();
        }
        this.lexer.nextToken();
        List<SQLCommentHint> hints = null;
        if (this.lexer.token == Token.HINT) {
            hints = this.exprParser.parseHints();
        }
        if (this.lexer.token == Token.TABLE || this.lexer.identifierEquals("TEMPORARY")) {
            SQLDropTableStatement dropTable = this.parseDropTable(false);
            if (hints != null) {
                dropTable.setHints(hints);
            }
            stmt = dropTable;
        } else if (this.lexer.token == Token.USER) {
            stmt = this.parseDropUser();
        } else if (this.lexer.token == Token.INDEX) {
            stmt = this.parseDropIndex();
        } else if (this.lexer.token == Token.VIEW) {
            stmt = this.parseDropView(false);
        } else if (this.lexer.token == Token.TRIGGER) {
            stmt = this.parseDropTrigger(false);
        } else if (this.lexer.token == Token.DATABASE) {
            stmt = this.parseDropDatabase(false);
        } else if (this.lexer.token == Token.FUNCTION) {
            stmt = this.parseDropFunction(false);
        } else if (this.lexer.token == Token.TABLESPACE) {
            stmt = this.parseDropTablespace(false);
        } else if (this.lexer.token == Token.PROCEDURE) {
            stmt = this.parseDropProcedure(false);
        } else if (this.lexer.token == Token.SEQUENCE) {
            stmt = this.parseDropSequece(false);
        } else {
            throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
        }
        if (beforeComments != null) {
            stmt.addBeforeComment(beforeComments);
        }
        return stmt;
    }

    public SQLStatement parseKill() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseCase() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseIf() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseWhile() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseDeclare() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseRepeat() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseLeave() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseReturn() {
        if (this.lexer.token == Token.RETURN || this.lexer.identifierEquals("RETURN")) {
            this.lexer.nextToken();
        }
        SQLReturnStatement stmt = new SQLReturnStatement();
        if (this.lexer.token != Token.SEMI) {
            SQLExpr expr = this.exprParser.expr();
            stmt.setExpr(expr);
        }
        this.accept(Token.SEMI);
        stmt.setAfterSemi(true);
        return stmt;
    }

    public SQLStatement parseUpsert() {
        SQLInsertStatement insertStatement = new SQLInsertStatement();
        if (this.lexer.token == Token.UPSERT || this.lexer.identifierEquals("UPSERT")) {
            this.lexer.nextToken();
            insertStatement.setUpsert(true);
        }
        this.parseInsert0(insertStatement);
        return insertStatement;
    }

    public SQLRollbackStatement parseRollback() {
        this.lexer.nextToken();
        if (this.lexer.identifierEquals("WORK")) {
            this.lexer.nextToken();
        }
        SQLRollbackStatement stmt = new SQLRollbackStatement(this.getDbType());
        if (this.lexer.token == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("SAVEPOINT") || this.lexer.token == Token.SAVEPOINT) {
                this.lexer.nextToken();
            }
            stmt.setTo(this.exprParser.name());
        }
        return stmt;
    }

    public SQLStatement parseCommit() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseShow() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLUseStatement parseUse() {
        this.accept(Token.USE);
        SQLUseStatement stmt = new SQLUseStatement(this.getDbType());
        stmt.setDatabase(this.exprParser.name());
        return stmt;
    }

    public SQLGrantStatement parseGrant() {
        this.accept(Token.GRANT);
        SQLGrantStatement stmt = new SQLGrantStatement(this.getDbType());
        this.parsePrivileages(stmt.getPrivileges(), stmt);
        if (this.lexer.token == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.PROCEDURE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.PROCEDURE);
            } else if (this.lexer.token == Token.FUNCTION) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.FUNCTION);
            } else if (this.lexer.token == Token.TABLE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.TABLE);
            } else if (this.lexer.token == Token.USER) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.USER);
            } else if (this.lexer.token == Token.DATABASE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.DATABASE);
            }
            if (stmt.getObjectType() != null && this.lexer.token == Token.COLONCOLON) {
                this.lexer.nextToken();
            }
            SQLExpr expr = this.exprParser.expr();
            if (stmt.getObjectType() == SQLObjectType.TABLE || stmt.getObjectType() == null) {
                stmt.setOn(new SQLExprTableSource(expr));
            } else {
                stmt.setOn(expr);
            }
        }
        if (this.lexer.token == Token.TO) {
            this.lexer.nextToken();
            stmt.setTo(this.exprParser.expr());
        }
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.identifierEquals("MAX_QUERIES_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxQueriesPerHour(this.exprParser.primary());
                    continue;
                }
                if (this.lexer.identifierEquals("MAX_UPDATES_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxUpdatesPerHour(this.exprParser.primary());
                    continue;
                }
                if (this.lexer.identifierEquals("MAX_CONNECTIONS_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxConnectionsPerHour(this.exprParser.primary());
                    continue;
                }
                if (!this.lexer.identifierEquals("MAX_USER_CONNECTIONS")) break;
                this.lexer.nextToken();
                stmt.setMaxUserConnections(this.exprParser.primary());
            }
        }
        if (this.lexer.identifierEquals("ADMIN")) {
            this.lexer.nextToken();
            this.acceptIdentifier("OPTION");
            stmt.setAdminOption(true);
        }
        if (this.lexer.token == Token.IDENTIFIED) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.identifierEquals("PASSWORD")) {
                this.lexer.nextToken();
                String password = this.lexer.stringVal();
                this.accept(Token.LITERAL_CHARS);
                stmt.setIdentifiedByPassword(password);
            } else {
                stmt.setIdentifiedBy(this.exprParser.expr());
            }
        }
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.GRANT) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTION");
                stmt.setWithGrantOption(true);
            }
        }
        return stmt;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parsePrivileages(List<SQLExpr> privileges, SQLObject parent) {
        while (true) {
            String privilege = null;
            if (this.lexer.token == Token.ALL) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("PRIVILEGES")) {
                    privilege = "ALL PRIVILEGES";
                    this.lexer.nextToken();
                } else {
                    privilege = "ALL";
                }
            } else if (this.lexer.token == Token.SELECT) {
                privilege = "SELECT";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.UPDATE) {
                privilege = "UPDATE";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.DELETE) {
                privilege = "DELETE";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.INSERT) {
                privilege = "INSERT";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.INDEX) {
                this.lexer.nextToken();
                privilege = "INDEX";
            } else if (this.lexer.token == Token.TRIGGER) {
                this.lexer.nextToken();
                privilege = "TRIGGER";
            } else if (this.lexer.token == Token.REFERENCES) {
                privilege = "REFERENCES";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.CREATE) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.TABLE) {
                    privilege = "CREATE TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.SESSION) {
                    privilege = "CREATE SESSION";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.TABLESPACE) {
                    privilege = "CREATE TABLESPACE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.USER) {
                    privilege = "CREATE USER";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.VIEW) {
                    privilege = "CREATE VIEW";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.PROCEDURE) {
                    privilege = "CREATE PROCEDURE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.SEQUENCE) {
                    privilege = "CREATE SEQUENCE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.ANY) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "CREATE ANY TABLE";
                    } else {
                        if (!this.lexer.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "CREATE ANY MATERIALIZED VIEW";
                    }
                } else if (this.lexer.identifierEquals("SYNONYM")) {
                    privilege = "CREATE SYNONYM";
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals("ROUTINE")) {
                    privilege = "CREATE ROUTINE";
                    this.lexer.nextToken();
                } else {
                    if (!this.lexer.identifierEquals("TEMPORARY")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                    this.lexer.nextToken();
                    this.accept(Token.TABLE);
                    privilege = "CREATE TEMPORARY TABLE";
                }
            } else if (this.lexer.token == Token.ALTER) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.TABLE) {
                    privilege = "ALTER TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.SESSION) {
                    privilege = "ALTER SESSION";
                    this.lexer.nextToken();
                } else {
                    if (this.lexer.token != Token.ANY) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "ALTER ANY TABLE";
                    } else {
                        if (!this.lexer.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "ALTER ANY MATERIALIZED VIEW";
                    }
                }
            } else if (this.lexer.token == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.DROP) {
                    privilege = "DROP TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.SESSION) {
                    privilege = "DROP SESSION";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.ANY) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "DROP ANY TABLE";
                    } else {
                        if (!this.lexer.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "DROP ANY MATERIALIZED VIEW";
                    }
                } else {
                    privilege = "DROP";
                }
            } else if (this.lexer.identifierEquals("USAGE")) {
                privilege = "USAGE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("EXECUTE")) {
                privilege = "EXECUTE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("PROXY")) {
                privilege = "PROXY";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("QUERY")) {
                this.lexer.nextToken();
                this.acceptIdentifier("REWRITE");
                privilege = "QUERY REWRITE";
            } else if (this.lexer.identifierEquals("GLOBAL")) {
                this.lexer.nextToken();
                this.acceptIdentifier("QUERY");
                this.acceptIdentifier("REWRITE");
                privilege = "GLOBAL QUERY REWRITE";
            } else if (this.lexer.identifierEquals("INHERIT")) {
                this.lexer.nextToken();
                this.acceptIdentifier("PRIVILEGES");
                privilege = "INHERIT PRIVILEGES";
            } else if (this.lexer.identifierEquals("EVENT")) {
                this.lexer.nextToken();
                privilege = "EVENT";
            } else if (this.lexer.identifierEquals("FILE")) {
                this.lexer.nextToken();
                privilege = "FILE";
            } else if (this.lexer.token == Token.GRANT) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTION");
                privilege = "GRANT OPTION";
            } else if (this.lexer.token == Token.LOCK) {
                this.lexer.nextToken();
                this.acceptIdentifier("TABLES");
                privilege = "LOCK TABLES";
            } else if (this.lexer.identifierEquals("PROCESS")) {
                this.lexer.nextToken();
                privilege = "PROCESS";
            } else if (this.lexer.identifierEquals("RELOAD")) {
                this.lexer.nextToken();
                privilege = "RELOAD";
            } else if (this.lexer.identifierEquals("RESOURCE")) {
                this.lexer.nextToken();
                privilege = "RESOURCE";
            } else if (this.lexer.token == Token.CONNECT) {
                this.lexer.nextToken();
                privilege = "CONNECT";
            } else if (this.lexer.identifierEquals("REPLICATION")) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("SLAVE")) {
                    this.lexer.nextToken();
                    privilege = "REPLICATION SLAVE";
                } else {
                    this.acceptIdentifier("CLIENT");
                    privilege = "REPLICATION CLIENT";
                }
            } else if (this.lexer.token == Token.SHOW) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.VIEW) {
                    this.lexer.nextToken();
                    privilege = "SHOW VIEW";
                } else {
                    this.acceptIdentifier("DATABASES");
                    privilege = "SHOW DATABASES";
                }
            } else if (this.lexer.identifierEquals("SHUTDOWN")) {
                this.lexer.nextToken();
                privilege = "SHUTDOWN";
            } else if (this.lexer.identifierEquals("SUPER")) {
                this.lexer.nextToken();
                privilege = "SUPER";
            } else if (this.lexer.identifierEquals("CONTROL")) {
                this.lexer.nextToken();
                privilege = "CONTROL";
            } else if (this.lexer.identifierEquals("IMPERSONATE")) {
                this.lexer.nextToken();
                privilege = "IMPERSONATE";
            }
            if (privilege != null) {
                void var4_4;
                SQLIdentifierExpr sQLIdentifierExpr = new SQLIdentifierExpr(privilege);
                if (this.lexer.token == Token.LPAREN) {
                    SQLExpr sQLExpr = this.exprParser.primaryRest(sQLIdentifierExpr);
                }
                var4_4.setParent(parent);
                privileges.add((SQLExpr)var4_4);
            }
            if (this.lexer.token != Token.COMMA) return;
            this.lexer.nextToken();
        }
    }

    public SQLRevokeStatement parseRevoke() {
        this.accept(Token.REVOKE);
        SQLRevokeStatement stmt = new SQLRevokeStatement(this.getDbType());
        this.parsePrivileages(stmt.getPrivileges(), stmt);
        if (this.lexer.token == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.PROCEDURE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.PROCEDURE);
            } else if (this.lexer.token == Token.FUNCTION) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.FUNCTION);
            } else if (this.lexer.token == Token.TABLE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.TABLE);
            } else if (this.lexer.token == Token.USER) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.USER);
            }
            SQLExpr expr = this.exprParser.expr();
            if (stmt.getObjectType() == SQLObjectType.TABLE || stmt.getObjectType() == null) {
                stmt.setOn(new SQLExprTableSource(expr));
            } else {
                stmt.setOn(expr);
            }
        }
        if (this.lexer.token == Token.FROM) {
            this.lexer.nextToken();
            stmt.setFrom(this.exprParser.expr());
        }
        return stmt;
    }

    public SQLStatement parseSavePoint() {
        this.acceptIdentifier("SAVEPOINT");
        SQLSavePointStatement stmt = new SQLSavePointStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseReleaseSavePoint() {
        this.acceptIdentifier("RELEASE");
        this.acceptIdentifier("SAVEPOINT");
        SQLReleaseSavePointStatement stmt = new SQLReleaseSavePointStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseAlter() {
        this.accept(Token.ALTER);
        if (this.lexer.token == Token.TABLE) {
            this.lexer.nextToken();
            SQLAlterTableStatement stmt = new SQLAlterTableStatement(this.getDbType());
            stmt.setName(this.exprParser.name());
            while (true) {
                if (this.lexer.token == Token.DROP) {
                    this.parseAlterDrop(stmt);
                    continue;
                }
                if (this.lexer.identifierEquals("ADD")) {
                    SQLConstraint constraint;
                    SQLAlterTableAddColumn item;
                    SQLAlterTableAddConstraint item2;
                    this.lexer.nextToken();
                    boolean ifNotExists = false;
                    if (this.lexer.token == Token.IF) {
                        this.lexer.nextToken();
                        this.accept(Token.NOT);
                        this.accept(Token.EXISTS);
                        ifNotExists = true;
                    }
                    if (this.lexer.token == Token.PRIMARY) {
                        SQLPrimaryKey primaryKey = this.exprParser.parsePrimaryKey();
                        item2 = new SQLAlterTableAddConstraint(primaryKey);
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.token == Token.IDENTIFIER) {
                        item = this.parseAlterTableAddColumn();
                        stmt.addItem(item);
                        continue;
                    }
                    if (this.lexer.token == Token.COLUMN) {
                        this.lexer.nextToken();
                        item = this.parseAlterTableAddColumn();
                        stmt.addItem(item);
                        continue;
                    }
                    if (this.lexer.token == Token.CHECK) {
                        SQLCheck check = this.exprParser.parseCheck();
                        item2 = new SQLAlterTableAddConstraint(check);
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.token == Token.CONSTRAINT) {
                        constraint = this.exprParser.parseConstaint();
                        item2 = new SQLAlterTableAddConstraint(constraint);
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.token == Token.FOREIGN) {
                        constraint = this.exprParser.parseForeignKey();
                        item2 = new SQLAlterTableAddConstraint(constraint);
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.token == Token.PARTITION) {
                        this.lexer.nextToken();
                        SQLAlterTableAddPartition addPartition = new SQLAlterTableAddPartition();
                        addPartition.setIfNotExists(ifNotExists);
                        this.accept(Token.LPAREN);
                        this.parseAssignItems(addPartition.getPartitions(), addPartition);
                        this.accept(Token.RPAREN);
                        stmt.addItem(addPartition);
                        continue;
                    }
                    throw new ParserException("TODO " + this.lexer.info());
                }
                if (this.lexer.token == Token.DISABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.CONSTRAINT) {
                        this.lexer.nextToken();
                        SQLAlterTableDisableConstraint item = new SQLAlterTableDisableConstraint();
                        item.setConstraintName(this.exprParser.name());
                        stmt.addItem(item);
                        continue;
                    }
                    if (this.lexer.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableDisableLifecycle item = new SQLAlterTableDisableLifecycle();
                        stmt.addItem(item);
                        continue;
                    }
                    this.acceptIdentifier("KEYS");
                    SQLAlterTableDisableKeys item = new SQLAlterTableDisableKeys();
                    stmt.addItem(item);
                    continue;
                }
                if (this.lexer.token == Token.ENABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.CONSTRAINT) {
                        this.lexer.nextToken();
                        SQLAlterTableEnableConstraint item = new SQLAlterTableEnableConstraint();
                        item.setConstraintName(this.exprParser.name());
                        stmt.addItem(item);
                        continue;
                    }
                    if (this.lexer.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableEnableLifecycle item = new SQLAlterTableEnableLifecycle();
                        stmt.addItem(item);
                        continue;
                    }
                    this.acceptIdentifier("KEYS");
                    SQLAlterTableEnableKeys item = new SQLAlterTableEnableKeys();
                    stmt.addItem(item);
                    continue;
                }
                if (this.lexer.token == Token.ALTER) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.COLUMN) {
                        SQLAlterTableAlterColumn alterColumn = this.parseAlterColumn();
                        stmt.addItem(alterColumn);
                        continue;
                    }
                    if (this.lexer.token == Token.LITERAL_ALIAS) {
                        SQLAlterTableAlterColumn alterColumn = this.parseAlterColumn();
                        stmt.addItem(alterColumn);
                        continue;
                    }
                    throw new ParserException("TODO " + this.lexer.info());
                }
                if (this.lexer.identifierEquals("CHANGE")) {
                    this.lexer.nextToken();
                    this.accept(Token.COLUMN);
                    SQLName columnName = this.exprParser.name();
                    if (this.lexer.identifierEquals("RENAME")) {
                        this.lexer.nextToken();
                        this.accept(Token.TO);
                        SQLName toName = this.exprParser.name();
                        SQLAlterTableRenameColumn renameColumn = new SQLAlterTableRenameColumn();
                        renameColumn.setColumn(columnName);
                        renameColumn.setTo(toName);
                        stmt.addItem(renameColumn);
                        continue;
                    }
                    if (this.lexer.token == Token.COMMENT) {
                        SQLExpr comment;
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.LITERAL_ALIAS) {
                            String alias = this.lexer.stringVal();
                            if (alias.length() > 2 && alias.charAt(0) == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                                alias = alias.substring(1, alias.length() - 1);
                            }
                            comment = new SQLCharExpr(alias);
                            this.lexer.nextToken();
                        } else {
                            comment = this.exprParser.primary();
                        }
                        SQLColumnDefinition column = new SQLColumnDefinition();
                        column.setDbType(this.dbType);
                        column.setName(columnName);
                        column.setComment(comment);
                        SQLAlterTableAlterColumn changeColumn = new SQLAlterTableAlterColumn();
                        changeColumn.setColumn(column);
                        stmt.addItem(changeColumn);
                        continue;
                    }
                    SQLColumnDefinition column = this.exprParser.parseColumn();
                    SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
                    alterColumn.setColumn(column);
                    alterColumn.setOriginColumn(columnName);
                    stmt.addItem(alterColumn);
                    continue;
                }
                if (this.lexer.token == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("NOCHECK");
                    this.acceptIdentifier("ADD");
                    SQLConstraint check = this.exprParser.parseConstaint();
                    SQLAlterTableAddConstraint addCheck = new SQLAlterTableAddConstraint();
                    addCheck.setWithNoCheck(true);
                    addCheck.setConstraint(check);
                    stmt.addItem(addCheck);
                    continue;
                }
                if (this.lexer.identifierEquals("RENAME")) {
                    stmt.addItem(this.parseAlterTableRename());
                    continue;
                }
                if (this.lexer.token == Token.SET) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.COMMENT) {
                        this.lexer.nextToken();
                        SQLAlterTableSetComment setComment = new SQLAlterTableSetComment();
                        setComment.setComment(this.exprParser.primary());
                        stmt.addItem(setComment);
                        continue;
                    }
                    if (this.lexer.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableSetLifecycle setLifecycle = new SQLAlterTableSetLifecycle();
                        setLifecycle.setLifecycle(this.exprParser.primary());
                        stmt.addItem(setLifecycle);
                        continue;
                    }
                    throw new ParserException("TODO " + this.lexer.info());
                }
                if (this.lexer.token == Token.PARTITION) {
                    this.lexer.nextToken();
                    SQLAlterTableRenamePartition renamePartition = new SQLAlterTableRenamePartition();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(renamePartition.getPartition(), renamePartition);
                    this.accept(Token.RPAREN);
                    if (this.lexer.token == Token.ENABLE) {
                        this.lexer.nextToken();
                        if (this.lexer.identifierEquals("LIFECYCLE")) {
                            this.lexer.nextToken();
                        }
                        SQLAlterTableEnableLifecycle enableLifeCycle = new SQLAlterTableEnableLifecycle();
                        for (SQLAssignItem condition : renamePartition.getPartition()) {
                            enableLifeCycle.getPartition().add(condition);
                            condition.setParent(enableLifeCycle);
                        }
                        stmt.addItem(enableLifeCycle);
                        continue;
                    }
                    if (this.lexer.token == Token.DISABLE) {
                        this.lexer.nextToken();
                        if (this.lexer.identifierEquals("LIFECYCLE")) {
                            this.lexer.nextToken();
                        }
                        SQLAlterTableDisableLifecycle disableLifeCycle = new SQLAlterTableDisableLifecycle();
                        for (SQLAssignItem condition : renamePartition.getPartition()) {
                            disableLifeCycle.getPartition().add(condition);
                            condition.setParent(disableLifeCycle);
                        }
                        stmt.addItem(disableLifeCycle);
                        continue;
                    }
                    this.acceptIdentifier("RENAME");
                    this.accept(Token.TO);
                    this.accept(Token.PARTITION);
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(renamePartition.getTo(), renamePartition);
                    this.accept(Token.RPAREN);
                    stmt.addItem(renamePartition);
                    continue;
                }
                if (this.lexer.identifierEquals("TOUCH")) {
                    this.lexer.nextToken();
                    SQLAlterTableTouch item = new SQLAlterTableTouch();
                    if (this.lexer.token == Token.PARTITION) {
                        this.lexer.nextToken();
                        this.accept(Token.LPAREN);
                        this.parseAssignItems(item.getPartition(), item);
                        this.accept(Token.RPAREN);
                    }
                    stmt.addItem(item);
                    continue;
                }
                if (!"odps".equals(this.dbType) || !this.lexer.identifierEquals("MERGE")) break;
                this.lexer.nextToken();
                this.acceptIdentifier("SMALLFILES");
                stmt.setMergeSmallFiles(true);
            }
            return stmt;
        }
        if (this.lexer.token == Token.VIEW) {
            this.lexer.nextToken();
            SQLName viewName = this.exprParser.name();
            if (this.lexer.identifierEquals("RENAME")) {
                this.lexer.nextToken();
                this.accept(Token.TO);
                SQLAlterViewRenameStatement stmt = new SQLAlterViewRenameStatement();
                stmt.setName(viewName);
                SQLName newName = this.exprParser.name();
                stmt.setTo(newName);
                return stmt;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLAlterTableItem parseAlterTableRename() {
        this.acceptIdentifier("RENAME");
        if (this.lexer.token == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableRenameColumn renameColumn = new SQLAlterTableRenameColumn();
            renameColumn.setColumn(this.exprParser.name());
            this.accept(Token.TO);
            renameColumn.setTo(this.exprParser.name());
            return renameColumn;
        }
        if (this.lexer.token == Token.TO) {
            this.lexer.nextToken();
            SQLAlterTableRename item = new SQLAlterTableRename();
            item.setTo(this.exprParser.name());
            return item;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLAlterTableAlterColumn parseAlterColumn() {
        this.lexer.nextToken();
        SQLColumnDefinition column = this.exprParser.parseColumn();
        SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
        alterColumn.setColumn(column);
        return alterColumn;
    }

    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        boolean ifExists = false;
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            ifExists = true;
        }
        if (this.lexer.token == Token.CONSTRAINT) {
            this.lexer.nextToken();
            SQLAlterTableDropConstraint item = new SQLAlterTableDropConstraint();
            item.setConstraintName(this.exprParser.name());
            stmt.addItem(item);
        } else if (this.lexer.token == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            if (this.lexer.token == Token.CASCADE) {
                item.setCascade(true);
                this.lexer.nextToken();
            }
            stmt.addItem(item);
        } else if (this.lexer.token == Token.LITERAL_ALIAS) {
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            if (this.lexer.token == Token.CASCADE) {
                item.setCascade(true);
                this.lexer.nextToken();
            }
            stmt.addItem(item);
        } else if (this.lexer.token == Token.PARTITION) {
            SQLAlterTableDropPartition dropPartition = this.parseAlterTableDropPartition(ifExists);
            stmt.addItem(dropPartition);
        } else if (this.lexer.token == Token.INDEX) {
            this.lexer.nextToken();
            SQLName indexName = this.exprParser.name();
            SQLAlterTableDropIndex item = new SQLAlterTableDropIndex();
            item.setIndexName(indexName);
            stmt.addItem(item);
        } else {
            throw new ParserException("TODO " + this.lexer.info());
        }
    }

    protected SQLAlterTableDropPartition parseAlterTableDropPartition(boolean ifExists) {
        this.lexer.nextToken();
        SQLAlterTableDropPartition dropPartition = new SQLAlterTableDropPartition();
        dropPartition.setIfExists(ifExists);
        if (this.lexer.token == Token.LPAREN) {
            this.accept(Token.LPAREN);
            this.parseAssignItems(dropPartition.getPartitions(), dropPartition);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals("PURGE")) {
                this.lexer.nextToken();
                dropPartition.setPurge(true);
            }
        } else {
            SQLName partition = this.exprParser.name();
            dropPartition.addPartition(partition);
        }
        return dropPartition;
    }

    public SQLStatement parseRename() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLDropTableStatement parseDropTable(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropTableStatement stmt = new SQLDropTableStatement(this.getDbType());
        if (this.lexer.identifierEquals("TEMPORARY")) {
            this.lexer.nextToken();
            stmt.setTemporary(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addPartition(new SQLExprTableSource(name));
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        while (true) {
            if (this.lexer.identifierEquals("RESTRICT")) {
                this.lexer.nextToken();
                stmt.setRestrict(true);
                continue;
            }
            if (this.lexer.identifierEquals("CASCADE")) {
                this.lexer.nextToken();
                stmt.setCascade(true);
                if (!this.lexer.identifierEquals("CONSTRAINTS")) continue;
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token != Token.PURGE && !this.lexer.identifierEquals("PURGE")) break;
            this.lexer.nextToken();
            stmt.setPurge(true);
        }
        return stmt;
    }

    protected SQLDropSequenceStatement parseDropSequece(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.lexer.nextToken();
        SQLName name = this.exprParser.name();
        SQLDropSequenceStatement stmt = new SQLDropSequenceStatement(this.getDbType());
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropTriggerStatement parseDropTrigger(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.lexer.nextToken();
        SQLName name = this.exprParser.name();
        SQLDropTriggerStatement stmt = new SQLDropTriggerStatement(this.getDbType());
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropViewStatement parseDropView(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropViewStatement stmt = new SQLDropViewStatement(this.getDbType());
        this.accept(Token.VIEW);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addPartition(new SQLExprTableSource(name));
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("RESTRICT")) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        } else if (this.lexer.identifierEquals("CASCADE")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CONSTRAINTS")) {
                this.lexer.nextToken();
            }
            stmt.setCascade(true);
        }
        return stmt;
    }

    protected SQLDropDatabaseStatement parseDropDatabase(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropDatabaseStatement stmt = new SQLDropDatabaseStatement(this.getDbType());
        this.accept(Token.DATABASE);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setDatabase(name);
        return stmt;
    }

    protected SQLDropFunctionStatement parseDropFunction(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropFunctionStatement stmt = new SQLDropFunctionStatement(this.getDbType());
        this.accept(Token.FUNCTION);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropTableSpaceStatement parseDropTablespace(boolean acceptDrop) {
        SQLDropTableSpaceStatement stmt = new SQLDropTableSpaceStatement(this.getDbType());
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            stmt.addBeforeComment(this.lexer.readAndResetComments());
        }
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.accept(Token.TABLESPACE);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropProcedureStatement parseDropProcedure(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropProcedureStatement stmt = new SQLDropProcedureStatement(this.getDbType());
        this.accept(Token.PROCEDURE);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    public SQLStatement parseTruncate() {
        this.accept(Token.TRUNCATE);
        if (this.lexer.token == Token.TABLE) {
            this.lexer.nextToken();
        }
        SQLTruncateStatement stmt = new SQLTruncateStatement(this.getDbType());
        if (this.lexer.token == Token.ONLY) {
            this.lexer.nextToken();
            stmt.setOnly(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addTableSource(name);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        while (true) {
            if (this.lexer.token == Token.PURGE) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("SNAPSHOT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("LOG");
                    stmt.setPurgeSnapshotLog(true);
                    continue;
                }
                throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
            }
            if (this.lexer.token == Token.RESTART) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                stmt.setRestartIdentity(Boolean.TRUE);
                continue;
            }
            if (this.lexer.token == Token.SHARE) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                stmt.setRestartIdentity(Boolean.FALSE);
                continue;
            }
            if (this.lexer.token == Token.CASCADE) {
                this.lexer.nextToken();
                stmt.setCascade(Boolean.TRUE);
                continue;
            }
            if (this.lexer.token == Token.RESTRICT) {
                this.lexer.nextToken();
                stmt.setCascade(Boolean.FALSE);
                continue;
            }
            if (this.lexer.token == Token.DROP) {
                this.lexer.nextToken();
                this.acceptIdentifier("STORAGE");
                stmt.setDropStorage(true);
                continue;
            }
            if (this.lexer.identifierEquals("REUSE")) {
                this.lexer.nextToken();
                this.acceptIdentifier("STORAGE");
                stmt.setReuseStorage(true);
                continue;
            }
            if (this.lexer.identifierEquals("IGNORE")) {
                this.lexer.nextToken();
                this.accept(Token.DELETE);
                this.acceptIdentifier("TRIGGERS");
                stmt.setIgnoreDeleteTriggers(true);
                continue;
            }
            if (this.lexer.identifierEquals("RESTRICT")) {
                this.lexer.nextToken();
                this.accept(Token.WHEN);
                this.accept(Token.DELETE);
                this.acceptIdentifier("TRIGGERS");
                stmt.setRestrictWhenDeleteTriggers(true);
                continue;
            }
            if (this.lexer.token == Token.CONTINUE) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                continue;
            }
            if (!this.lexer.identifierEquals("IMMEDIATE")) break;
            this.lexer.nextToken();
            stmt.setImmediate(true);
        }
        return stmt;
    }

    public SQLStatement parseInsert() {
        SQLInsertStatement stmt = new SQLInsertStatement();
        if (this.lexer.token == Token.INSERT) {
            this.accept(Token.INSERT);
        }
        this.parseInsert0(stmt);
        return stmt;
    }

    protected void parseInsert0(SQLInsertInto insertStatement) {
        this.parseInsert0(insertStatement, true);
    }

    protected void parseInsert0_hinits(SQLInsertInto insertStatement) {
    }

    protected void parseInsert0(SQLInsertInto insertStatement, boolean acceptSubQuery) {
        if (this.lexer.token == Token.INTO) {
            this.lexer.nextToken();
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token == Token.LITERAL_ALIAS) {
                insertStatement.setAlias(this.tableAlias());
            }
            this.parseInsert0_hinits(insertStatement);
            if (this.lexer.token == Token.IDENTIFIER) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.parseInsertColumns(insertStatement);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                SQLInsertStatement.ValuesClause values;
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    values = new SQLInsertStatement.ValuesClause();
                    this.exprParser.exprList(values.getValues(), values);
                    insertStatement.addValueCause(values);
                    this.accept(Token.RPAREN);
                } else {
                    values = new SQLInsertStatement.ValuesClause();
                    SQLExpr value = this.exprParser.expr();
                    values.addValue(value);
                    insertStatement.addValueCause(values);
                }
                if (this.lexer.token == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (acceptSubQuery && (this.lexer.token == Token.SELECT || this.lexer.token == Token.LPAREN)) {
            SQLSelect select = this.createSQLSelectParser().select();
            insertStatement.setQuery(select);
        }
    }

    protected void parseInsertColumns(SQLInsertInto insert) {
        this.exprParser.exprList(insert.getColumns(), insert);
    }

    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        return false;
    }

    public SQLDropUserStatement parseDropUser() {
        this.accept(Token.USER);
        SQLDropUserStatement stmt = new SQLDropUserStatement(this.getDbType());
        while (true) {
            SQLExpr expr = this.exprParser.expr();
            stmt.addUser(expr);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseDropIndex() {
        this.accept(Token.INDEX);
        SQLDropIndexStatement stmt = new SQLDropIndexStatement(this.getDbType());
        stmt.setIndexName(this.exprParser.name());
        if (this.lexer.token == Token.ON) {
            this.lexer.nextToken();
            stmt.setTableName(this.exprParser.name());
        }
        return stmt;
    }

    public SQLCallStatement parseCall() {
        boolean brace = false;
        if (this.lexer.token == Token.LBRACE) {
            this.lexer.nextToken();
            brace = true;
        }
        SQLCallStatement stmt = new SQLCallStatement(this.getDbType());
        if (this.lexer.token == Token.QUES) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            stmt.setOutParameter(new SQLVariantRefExpr("?"));
        }
        this.acceptIdentifier("CALL");
        stmt.setProcedureName(this.exprParser.name());
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters(), stmt);
            this.accept(Token.RPAREN);
        }
        if (brace) {
            this.accept(Token.RBRACE);
            stmt.setBrace(true);
        }
        return stmt;
    }

    public SQLStatement parseSet() {
        this.accept(Token.SET);
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }

    public void parseAssignItems(List<? super SQLAssignItem> items, SQLObject parent) {
        while (true) {
            SQLAssignItem item = this.exprParser.parseAssignItem();
            item.setParent(parent);
            items.add(item);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    public SQLStatement parseCreatePackage() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseCreate() {
        char markChar = this.lexer.current();
        int markBp = this.lexer.bp();
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.CREATE);
        Token token = this.lexer.token;
        if (token == Token.TABLE || this.lexer.identifierEquals("GLOBAL")) {
            SQLCreateTableParser createTableParser = this.getSQLCreateTableParser();
            SQLCreateTableStatement stmt = createTableParser.parseCreateTable(false);
            if (comments != null) {
                stmt.addBeforeComment(comments);
            }
            return stmt;
        }
        if (token == Token.INDEX || token == Token.UNIQUE || this.lexer.identifierEquals("NONCLUSTERED")) {
            return this.parseCreateIndex(false);
        }
        if (this.lexer.token == Token.SEQUENCE) {
            return this.parseCreateSequence(false);
        }
        if (token == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            if (this.lexer.identifierEquals("FORCE")) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.PROCEDURE) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateProcedure();
            }
            if (this.lexer.token == Token.VIEW) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateView();
            }
            if (this.lexer.token == Token.TRIGGER) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateTrigger();
            }
            if (this.lexer.token == Token.FUNCTION) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateFunction();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PACKAGE)) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreatePackage();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TYPE)) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateType();
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (token == Token.DATABASE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("LINK")) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateDbLink();
            }
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateDatabase();
        }
        if (this.lexer.token == Token.USER) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateUser();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PUBLIC)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("SYNONYM")) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateSynonym();
            }
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateDbLink();
        }
        if (this.lexer.identifierEquals("SHARE")) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateDbLink();
        }
        if (this.lexer.identifierEquals("SYNONYM")) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateSynonym();
        }
        if (token == Token.VIEW) {
            return this.parseCreateView();
        }
        if (token == Token.TRIGGER) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateTrigger();
        }
        if (token == Token.PROCEDURE) {
            SQLCreateProcedureStatement stmt = this.parseCreateProcedure();
            stmt.setCreate(true);
            return stmt;
        }
        if (token == Token.FUNCTION) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            SQLCreateFunctionStatement stmt = this.parseCreateFunction();
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.BITMAP)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateIndex(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateMaterializedView();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TYPE)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateType();
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateType() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateUser() {
        this.accept(Token.CREATE);
        this.accept(Token.USER);
        SQLCreateUserStatement stmt = new SQLCreateUserStatement();
        stmt.setUser(this.exprParser.name());
        this.accept(Token.IDENTIFIED);
        this.accept(Token.BY);
        stmt.setPassword(this.exprParser.primary());
        return stmt;
    }

    public SQLCreateFunctionStatement parseCreateFunction() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateMaterializedView() {
        this.accept(Token.CREATE);
        this.acceptIdentifier("MATERIALIZED");
        this.accept(Token.VIEW);
        SQLCreateMaterializedViewStatement stmt = new SQLCreateMaterializedViewStatement();
        stmt.setName(this.exprParser.name());
        block0: while (true) {
            if (this.exprParser instanceof OracleExprParser) {
                ((OracleExprParser)this.exprParser).parseSegmentAttributes(stmt);
            }
            if (this.lexer.identifierEquals("REFRESH")) {
                this.lexer.nextToken();
                while (true) {
                    if (this.lexer.identifierEquals("FAST")) {
                        this.lexer.nextToken();
                        stmt.setRefreshFast(true);
                        continue;
                    }
                    if (this.lexer.identifierEquals("COMPLETE")) {
                        this.lexer.nextToken();
                        stmt.setRefreshComlete(true);
                        continue;
                    }
                    if (this.lexer.identifierEquals("FORCE")) {
                        this.lexer.nextToken();
                        stmt.setRefreshForce(true);
                        continue;
                    }
                    if (this.lexer.token != Token.ON) continue block0;
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.COMMIT) {
                        this.lexer.nextToken();
                        stmt.setRefreshOnCommit(true);
                        continue;
                    }
                    this.acceptIdentifier("DEMAND");
                    stmt.setRefreshOnDemand(true);
                }
            }
            if (this.lexer.identifierEquals("BUILD")) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("IMMEDIATE") || this.lexer.token == Token.IMMEDIATE) {
                    this.lexer.nextToken();
                    stmt.setBuildImmediate(true);
                    continue;
                }
                this.acceptIdentifier("DEFERRED");
                stmt.setBuildDeferred(true);
                continue;
            }
            if (!this.lexer.identifierEquals("PARALLEL")) break;
            this.lexer.nextToken();
            stmt.setParallel(true);
            if (this.lexer.token != Token.LITERAL_INT) continue;
            stmt.setParallelValue(this.lexer.integerValue().intValue());
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.ENABLE) {
            this.lexer.nextToken();
            this.acceptIdentifier("QUERY");
            this.acceptIdentifier("REWRITE");
            stmt.setEnableQueryRewrite(true);
        }
        this.accept(Token.AS);
        SQLSelect select = this.createSQLSelectParser().select();
        stmt.setQuery(select);
        return stmt;
    }

    public SQLStatement parseCreateDbLink() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateSynonym() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateTrigger() {
        List<SQLStatement> body;
        SQLCreateTriggerStatement stmt = new SQLCreateTriggerStatement(this.getDbType());
        if (this.lexer.token == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.OR) {
                this.lexer.nextToken();
                this.accept(Token.REPLACE);
                stmt.setOrReplace(true);
            }
        }
        this.accept(Token.TRIGGER);
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals(FnvHash.Constants.BEFORE)) {
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.BEFORE);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.AFTER)) {
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.AFTER);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.INSTEAD)) {
            this.lexer.nextToken();
            this.accept(Token.OF);
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.INSTEAD_OF);
        }
        while (true) {
            if (this.lexer.token == Token.INSERT) {
                this.lexer.nextToken();
                stmt.setInsert(true);
            } else if (this.lexer.token == Token.UPDATE) {
                this.lexer.nextToken();
                stmt.setUpdate(true);
                if (this.lexer.token == Token.OF) {
                    this.lexer.nextToken();
                    this.exprParser.names(stmt.getUpdateOfColumns(), stmt);
                }
            } else if (this.lexer.token == Token.DELETE) {
                this.lexer.nextToken();
                stmt.setDelete(true);
            }
            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.OR) break;
            this.lexer.nextToken();
        }
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.name());
        if (this.lexer.token == Token.FOR) {
            this.lexer.nextToken();
            this.acceptIdentifier("EACH");
            this.accept(Token.ROW);
            stmt.setForEachRow(true);
        }
        if (this.lexer.token == Token.WHEN) {
            this.lexer.nextToken();
            SQLExpr condition = this.exprParser.expr();
            stmt.setWhen(condition);
        }
        if ((body = this.parseStatementList()) == null || body.isEmpty()) {
            throw new ParserException("syntax error");
        }
        stmt.setBody(body.get(0));
        return stmt;
    }

    public SQLStatement parseBlock() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateDatabase() {
        if (this.lexer.token == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.accept(Token.DATABASE);
        SQLCreateDatabaseStatement stmt = new SQLCreateDatabaseStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLCreateProcedureStatement parseCreateProcedure() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateSequence(boolean acceptCreate) {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        SQLCreateIndexStatement stmt = new SQLCreateIndexStatement(this.getDbType());
        if (this.lexer.token == Token.UNIQUE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CLUSTERED")) {
                this.lexer.nextToken();
                stmt.setType("UNIQUE CLUSTERED");
            } else {
                stmt.setType("UNIQUE");
            }
        } else if (this.lexer.identifierEquals("FULLTEXT")) {
            stmt.setType("FULLTEXT");
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("NONCLUSTERED")) {
            stmt.setType("NONCLUSTERED");
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        stmt.setName(this.exprParser.name());
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            item.setParent(stmt);
            stmt.addItem(item);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return stmt;
    }

    public SQLCreateTableParser getSQLCreateTableParser() {
        return new SQLCreateTableParser(this.exprParser);
    }

    public SQLStatement parseSelect() {
        SQLSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        return new SQLSelectStatement(select, this.getDbType());
    }

    public SQLSelectParser createSQLSelectParser() {
        return new SQLSelectParser(this.exprParser, this.selectListCache);
    }

    public SQLUpdateStatement parseUpdateStatement() {
        SQLUpdateStatement udpateStatement = this.createUpdateStatement();
        if (this.lexer.token == Token.UPDATE) {
            this.lexer.nextToken();
            SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
            udpateStatement.setTableSource(tableSource);
        }
        this.parseUpdateSet(udpateStatement);
        if (this.lexer.token == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        return udpateStatement;
    }

    protected void parseUpdateSet(SQLUpdateStatement update) {
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
            update.addItem(item);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    protected SQLUpdateStatement createUpdateStatement() {
        return new SQLUpdateStatement(this.getDbType());
    }

    public SQLDeleteStatement parseDeleteStatement() {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement(this.getDbType());
        if (this.lexer.token == Token.DELETE) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.FROM) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.COMMENT) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            deleteStatement.setTableName(tableName);
            if (this.lexer.token == Token.FROM) {
                this.lexer.nextToken();
                SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setFrom(tableSource);
            }
        }
        if (this.lexer.token == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        return deleteStatement;
    }

    public SQLCreateTableStatement parseCreateTable() {
        throw new ParserException("TODO");
    }

    public SQLCreateViewStatement parseCreateView() {
        SQLCreateViewStatement createView = new SQLCreateViewStatement(this.getDbType());
        if (this.lexer.token == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            createView.setOrReplace(true);
        }
        if (this.lexer.identifierEquals("ALGORITHM")) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            String algorithm = this.lexer.stringVal();
            createView.setAlgorithm(algorithm);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("DEFINER")) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = this.exprParser.name();
            createView.setDefiner(definer);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("SQL")) {
            this.lexer.nextToken();
            this.acceptIdentifier("SECURITY");
            String sqlSecurity = this.lexer.stringVal();
            createView.setSqlSecurity(sqlSecurity);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("FORCE")) {
            this.lexer.nextToken();
            createView.setForce(true);
        }
        this.accept(Token.VIEW);
        if (this.lexer.token == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createView.setIfNotExists(true);
        }
        createView.setName(this.exprParser.name());
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token == Token.CONSTRAINT) {
                    SQLTableConstraint constraint = (SQLTableConstraint)this.exprParser.parseConstaint();
                    createView.addColumn(constraint);
                } else {
                    SQLColumnDefinition column = new SQLColumnDefinition();
                    column.setDbType(this.dbType);
                    SQLName expr = this.exprParser.name();
                    column.setName(expr);
                    this.exprParser.parseColumnRest(column);
                    if (this.lexer.token == Token.COMMENT) {
                        SQLExpr comment;
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.LITERAL_ALIAS) {
                            String alias = this.lexer.stringVal();
                            if (alias.length() > 2 && alias.charAt(0) == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                                alias = alias.substring(1, alias.length() - 1);
                            }
                            comment = new SQLCharExpr(alias);
                            this.lexer.nextToken();
                        } else {
                            comment = this.exprParser.primary();
                        }
                        column.setComment(comment);
                    }
                    column.setParent(createView);
                    createView.addColumn(column);
                }
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token == Token.COMMENT) {
            this.lexer.nextToken();
            SQLCharExpr comment = (SQLCharExpr)this.exprParser.primary();
            createView.setComment(comment);
        }
        this.accept(Token.AS);
        SQLSelectParser selectParser = this.createSQLSelectParser();
        createView.setSubQuery(selectParser.select());
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CASCADED")) {
                createView.setWithCascaded(true);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("LOCAL")) {
                createView.setWithLocal(true);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("READ")) {
                this.lexer.nextToken();
                this.accept(Token.ONLY);
                createView.setWithReadOnly(true);
            }
            if (this.lexer.token == Token.CHECK) {
                this.lexer.nextToken();
                createView.setWithCheckOption(true);
            }
        }
        return createView;
    }

    public SQLCommentStatement parseComment() {
        this.accept(Token.COMMENT);
        SQLCommentStatement stmt = new SQLCommentStatement();
        this.accept(Token.ON);
        if (this.lexer.token == Token.TABLE) {
            stmt.setType(SQLCommentStatement.Type.TABLE);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.COLUMN) {
            stmt.setType(SQLCommentStatement.Type.COLUMN);
            this.lexer.nextToken();
        }
        stmt.setOn(this.exprParser.name());
        this.accept(Token.IS);
        stmt.setComment(this.exprParser.expr());
        return stmt;
    }

    protected SQLAlterTableAddColumn parseAlterTableAddColumn() {
        boolean odps = "odps".equals(this.dbType);
        if (odps) {
            this.acceptIdentifier("COLUMNS");
            this.accept(Token.LPAREN);
        }
        SQLAlterTableAddColumn item = new SQLAlterTableAddColumn();
        do {
            SQLColumnDefinition columnDef = this.exprParser.parseColumn();
            item.addColumn(columnDef);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        } while (!this.lexer.identifierEquals("ADD"));
        if (odps) {
            this.accept(Token.RPAREN);
        }
        return item;
    }

    public SQLStatement parseStatement() {
        if (this.lexer.token == Token.SELECT) {
            return this.parseSelect();
        }
        if (this.lexer.token == Token.INSERT) {
            return this.parseInsert();
        }
        if (this.lexer.token == Token.UPDATE) {
            return this.parseUpdateStatement();
        }
        if (this.lexer.token == Token.DELETE) {
            return this.parseDeleteStatement();
        }
        ArrayList<SQLStatement> list = new ArrayList<SQLStatement>(1);
        this.parseStatementList(list, 1, null);
        return (SQLStatement)list.get(0);
    }

    public SQLStatement parseStatement(boolean tryBest) {
        ArrayList<SQLStatement> list = new ArrayList<SQLStatement>();
        this.parseStatementList(list, 1, null);
        if (tryBest && this.lexer.token != Token.EOF) {
            throw new ParserException("sql syntax error, no terminated. " + (Object)((Object)this.lexer.token));
        }
        return (SQLStatement)list.get(0);
    }

    public SQLExplainStatement parseExplain() {
        this.accept(Token.EXPLAIN);
        if (this.lexer.identifierEquals("PLAN")) {
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.FOR) {
            this.lexer.nextToken();
        }
        SQLExplainStatement explain = new SQLExplainStatement(this.getDbType());
        if (this.lexer.token == Token.HINT) {
            explain.setHints(this.exprParser.parseHints());
        }
        if ("mysql".equals(this.dbType) && (this.lexer.identifierEquals("FORMAT") || this.lexer.identifierEquals("EXTENDED") || this.lexer.identifierEquals("PARTITIONS"))) {
            explain.setType(this.lexer.stringVal);
            this.lexer.nextToken();
        }
        explain.setStatement(this.parseStatement());
        return explain;
    }

    protected SQLAlterTableAddIndex parseAlterTableAddIndex() {
        SQLAlterTableAddIndex item = new SQLAlterTableAddIndex();
        if (this.lexer.identifierEquals("FULLTEXT")) {
            this.lexer.nextToken();
            item.setType("FULLTEXT");
        }
        if (this.lexer.token == Token.UNIQUE) {
            item.setUnique(true);
            this.lexer.nextToken();
            if (this.lexer.token == Token.INDEX) {
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.KEY) {
                item.setKey(true);
                this.lexer.nextToken();
            }
        } else if (this.lexer.token == Token.INDEX) {
            this.accept(Token.INDEX);
        } else if (this.lexer.token == Token.KEY) {
            item.setKey(true);
            this.accept(Token.KEY);
        }
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
        } else {
            item.setName(this.exprParser.name());
            if ("mysql".equals(this.dbType) && this.lexer.identifierEquals("USING")) {
                this.lexer.nextToken();
                String indexType = this.lexer.stringVal;
                item.setType(indexType);
                this.accept(Token.IDENTIFIER);
            }
            this.accept(Token.LPAREN);
        }
        while (true) {
            SQLSelectOrderByItem column = this.exprParser.parseSelectOrderByItem();
            item.addItem(column);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return item;
    }

    public SQLOpenStatement parseOpen() {
        SQLOpenStatement stmt = new SQLOpenStatement();
        this.accept(Token.OPEN);
        stmt.setCursorName(this.exprParser.name());
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.names(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token == Token.FOR) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.SELECT) {
                SQLSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                SQLQueryExpr queryExpr = new SQLQueryExpr(select);
                stmt.setFor(queryExpr);
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
        this.accept(Token.SEMI);
        stmt.setAfterSemi(true);
        return stmt;
    }

    public SQLFetchStatement parseFetch() {
        this.accept(Token.FETCH);
        SQLFetchStatement stmt = new SQLFetchStatement();
        stmt.setCursorName(this.exprParser.name());
        if (this.lexer.identifierEquals("BULK")) {
            this.lexer.nextToken();
            this.acceptIdentifier("COLLECT");
            stmt.setBulkCollect(true);
        }
        this.accept(Token.INTO);
        while (true) {
            stmt.getInto().add(this.exprParser.name());
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseClose() {
        SQLCloseStatement stmt = new SQLCloseStatement();
        this.accept(Token.CLOSE);
        stmt.setCursorName(this.exprParser.name());
        this.accept(Token.SEMI);
        stmt.setAfterSemi(true);
        return stmt;
    }

    public boolean isParseCompleteValues() {
        return this.parseCompleteValues;
    }

    public void setParseCompleteValues(boolean parseCompleteValues) {
        this.parseCompleteValues = parseCompleteValues;
    }

    public int getParseValuesSize() {
        return this.parseValuesSize;
    }

    public void setParseValuesSize(int parseValuesSize) {
        this.parseValuesSize = parseValuesSize;
    }

    public SQLStatement parseMerge() {
        this.accept(Token.MERGE);
        SQLMergeStatement stmt = new SQLMergeStatement();
        stmt.setDbType(this.dbType);
        this.parseHints(stmt.getHints());
        this.accept(Token.INTO);
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelect select = this.createSQLSelectParser().select();
            SQLSubqueryTableSource tableSource = new SQLSubqueryTableSource(select);
            stmt.setInto(tableSource);
            this.accept(Token.RPAREN);
        } else {
            stmt.setInto(this.exprParser.name());
        }
        stmt.getInto().setAlias(this.tableAlias());
        this.accept(Token.USING);
        SQLTableSource using = this.createSQLSelectParser().parseTableSource();
        stmt.setUsing(using);
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.expr());
        boolean insertFlag = false;
        if (this.lexer.token == Token.WHEN) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.MATCHED) {
                SQLMergeStatement.MergeUpdateClause updateClause = new SQLMergeStatement.MergeUpdateClause();
                this.lexer.nextToken();
                this.accept(Token.THEN);
                this.accept(Token.UPDATE);
                this.accept(Token.SET);
                while (true) {
                    SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                    updateClause.addItem(item);
                    item.setParent(updateClause);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                if (this.lexer.token == Token.WHERE) {
                    this.lexer.nextToken();
                    updateClause.setWhere(this.exprParser.expr());
                }
                if (this.lexer.token == Token.DELETE) {
                    this.lexer.nextToken();
                    this.accept(Token.WHERE);
                    updateClause.setWhere(this.exprParser.expr());
                }
                stmt.setUpdateClause(updateClause);
            } else if (this.lexer.token == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (!insertFlag) {
            if (this.lexer.token == Token.WHEN) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (insertFlag) {
            SQLMergeStatement.MergeInsertClause insertClause = new SQLMergeStatement.MergeInsertClause();
            this.accept(Token.MATCHED);
            this.accept(Token.THEN);
            this.accept(Token.INSERT);
            if (this.lexer.token == Token.LPAREN) {
                this.accept(Token.LPAREN);
                this.exprParser.exprList(insertClause.getColumns(), insertClause);
                this.accept(Token.RPAREN);
            }
            this.accept(Token.VALUES);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(insertClause.getValues(), insertClause);
            this.accept(Token.RPAREN);
            if (this.lexer.token == Token.WHERE) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            stmt.setInsertClause(insertClause);
        }
        SQLErrorLoggingClause errorClause = this.parseErrorLoggingClause();
        stmt.setErrorLoggingClause(errorClause);
        return stmt;
    }

    protected SQLErrorLoggingClause parseErrorLoggingClause() {
        if (this.lexer.identifierEquals("LOG")) {
            SQLErrorLoggingClause errorClause = new SQLErrorLoggingClause();
            this.lexer.nextToken();
            this.accept(Token.ERRORS);
            if (this.lexer.token == Token.INTO) {
                this.lexer.nextToken();
                errorClause.setInto(this.exprParser.name());
            }
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                errorClause.setSimpleExpression(this.exprParser.expr());
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token == Token.REJECT) {
                this.lexer.nextToken();
                this.accept(Token.LIMIT);
                errorClause.setLimit(this.exprParser.expr());
            }
            return errorClause;
        }
        return null;
    }

    public void parseHints(List<SQLHint> hints) {
        this.getExprParser().parseHints(hints);
    }

    public SQLStatement parseDescribe() {
        if (this.lexer.token != Token.DESC && !this.lexer.identifierEquals("DESCRIBE")) {
            throw new ParserException("expect DESC, actual " + (Object)((Object)this.lexer.token));
        }
        this.lexer.nextToken();
        SQLDescribeStatement stmt = new SQLDescribeStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.identifierEquals("ROLE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.ROLE);
        } else if (this.lexer.identifierEquals("PACKAGE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.PACKAGE);
        } else if (this.lexer.identifierEquals("INSTANCE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.INSTANCE);
        }
        stmt.setObject(this.exprParser.name());
        Token token = this.lexer.token;
        if (token == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                stmt.getPartition().add(this.exprParser.expr());
                if (this.lexer.token == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                if (this.lexer.token == Token.RPAREN) break;
            }
            this.lexer.nextToken();
        } else if (token == Token.IDENTIFIER) {
            SQLName column = this.exprParser.name();
            stmt.setColumn(column);
        }
        return stmt;
    }

    public SQLWithSubqueryClause parseWithQuery() {
        this.accept(Token.WITH);
        SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
        if (this.lexer.token == Token.RECURSIVE || this.lexer.identifierEquals("RECURSIVE")) {
            this.lexer.nextToken();
            withQueryClause.setRecursive(true);
        }
        while (true) {
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            entry.setParent(withQueryClause);
            String alias = this.lexer.stringVal();
            this.lexer.nextToken();
            entry.setAlias(alias);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(entry.getColumns());
                this.accept(Token.RPAREN);
            }
            this.accept(Token.AS);
            this.accept(Token.LPAREN);
            switch (this.lexer.token) {
                case SELECT: 
                case VALUES: {
                    entry.setSubQuery(this.createSQLSelectParser().select());
                    break;
                }
                case INSERT: {
                    entry.setReturningStatement(this.parseInsert());
                    break;
                }
                case UPDATE: {
                    entry.setReturningStatement(this.parseUpdateStatement());
                    break;
                }
                case DELETE: {
                    entry.setReturningStatement(this.parseDeleteStatement());
                    break;
                }
            }
            this.accept(Token.RPAREN);
            withQueryClause.addEntry(entry);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withQueryClause;
    }

    public SQLStatement parseWith() {
        SQLWithSubqueryClause with = this.parseWithQuery();
        if (this.lexer.token == Token.SELECT) {
            SQLSelectParser selectParser = this.createSQLSelectParser();
            SQLSelect select = selectParser.select();
            select.setWithSubQuery(with);
            return new SQLSelectStatement(select, this.dbType);
        }
        throw new ParserException("TODO. " + this.lexer.info());
    }

    protected void parseValueClause(List<SQLInsertStatement.ValuesClause> valueClauseList, int columnSize, SQLObject parent) {
        int i = 0;
        while (true) {
            int startPos = this.lexer.pos() - 1;
            if (this.lexer.token() != Token.LPAREN) {
                throw new ParserException("syntax error, expect ')', " + this.lexer.info());
            }
            this.lexer.nextTokenValue();
            if (this.lexer.token() != Token.RPAREN) {
                ArrayList<SQLExpr> valueExprList = columnSize > 0 ? new ArrayList(columnSize) : new ArrayList<SQLExpr>();
                while (true) {
                    SQLExpr expr;
                    if (this.lexer.token() == Token.LITERAL_INT) {
                        expr = new SQLIntegerExpr(this.lexer.integerValue());
                        this.lexer.nextTokenComma();
                    } else if (this.lexer.token() == Token.LITERAL_CHARS) {
                        expr = new SQLCharExpr(this.lexer.stringVal());
                        this.lexer.nextTokenComma();
                    } else if (this.lexer.token() == Token.LITERAL_NCHARS) {
                        expr = new SQLNCharExpr(this.lexer.stringVal());
                        this.lexer.nextTokenComma();
                    } else {
                        expr = this.exprParser.expr();
                    }
                    if (this.lexer.token() == Token.COMMA) {
                        valueExprList.add(expr);
                        this.lexer.nextTokenValue();
                        continue;
                    }
                    if (this.lexer.token() == Token.RPAREN) {
                        valueExprList.add(expr);
                        break;
                    }
                    expr = this.exprParser.primaryRest(expr);
                    if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.RPAREN) {
                        expr = this.exprParser.exprRest(expr);
                    }
                    valueExprList.add(expr);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause(valueExprList);
                values.setParent(parent);
                if (this.lexer.isEnabled(SQLParserFeature.KeepInsertValueClauseOriginalString)) {
                    int endPos = this.lexer.pos();
                    String orginalString = this.lexer.subString(startPos, endPos - startPos);
                    values.setOriginalString(orginalString);
                }
                valueClauseList.add(values);
            } else {
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause(new ArrayList<SQLExpr>(0));
                valueClauseList.add(values);
            }
            if (this.lexer.token() != Token.RPAREN) {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            if (!this.parseCompleteValues && valueClauseList.size() >= this.parseValuesSize) {
                this.lexer.skipToEOF();
                break;
            }
            this.lexer.nextTokenComma();
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextTokenLParen();
            ++i;
        }
    }

    public SQLSelectListCache getSelectListCache() {
        return this.selectListCache;
    }

    public void setSelectListCache(SQLSelectListCache selectListCache) {
        this.selectListCache = selectListCache;
    }
}

