/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

public class CharTypes {
    private static final boolean[] hexFlags;
    private static final boolean[] firstIdentifierFlags;
    private static final boolean[] identifierFlags;
    private static final boolean[] whitespaceFlags;

    public static boolean isHex(char c) {
        return c < '\u0100' && hexFlags[c];
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isFirstIdentifierChar(char c) {
        if (c <= firstIdentifierFlags.length) {
            return firstIdentifierFlags[c];
        }
        return c != '\u3000' && c != '\uff0c';
    }

    public static boolean isIdentifierChar(char c) {
        if (c <= identifierFlags.length) {
            return identifierFlags[c];
        }
        return c != '\u3000' && c != '\uff0c';
    }

    public static boolean isWhitespace(char c) {
        return c <= whitespaceFlags.length && whitespaceFlags[c] || c == '\u3000';
    }

    static {
        int c;
        hexFlags = new boolean[256];
        for (c = 0; c < hexFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 70) {
                CharTypes.hexFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 102) {
                CharTypes.hexFlags[c] = true;
                continue;
            }
            if (c < 48 || c > 57) continue;
            CharTypes.hexFlags[c] = true;
        }
        firstIdentifierFlags = new boolean[256];
        for (c = 0; c < firstIdentifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                CharTypes.firstIdentifierFlags[c] = true;
                continue;
            }
            if (c < 97 || c > 122) continue;
            CharTypes.firstIdentifierFlags[c] = true;
        }
        CharTypes.firstIdentifierFlags[96] = true;
        CharTypes.firstIdentifierFlags[95] = true;
        CharTypes.firstIdentifierFlags[36] = true;
        identifierFlags = new boolean[256];
        for (c = 0; c < identifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                CharTypes.identifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                CharTypes.identifierFlags[c] = true;
                continue;
            }
            if (c < 48 || c > 57) continue;
            CharTypes.identifierFlags[c] = true;
        }
        CharTypes.identifierFlags[95] = true;
        CharTypes.identifierFlags[36] = true;
        CharTypes.identifierFlags[35] = true;
        whitespaceFlags = new boolean[256];
        CharTypes.whitespaceFlags[32] = true;
        CharTypes.whitespaceFlags[10] = true;
        CharTypes.whitespaceFlags[13] = true;
        CharTypes.whitespaceFlags[9] = true;
        CharTypes.whitespaceFlags[12] = true;
        CharTypes.whitespaceFlags[8] = true;
        CharTypes.whitespaceFlags[160] = true;
    }
}

