/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.jdbc;

import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementExecuteType;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.proxy.jdbc.WrapperProxyImpl;
import com.alibaba.druid.stat.JdbcSqlStat;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StatementProxyImpl
extends WrapperProxyImpl
implements StatementProxy {
    private final ConnectionProxy connection;
    private final Statement statement;
    protected String lastExecuteSql;
    protected long lastExecuteStartNano;
    protected long lastExecuteTimeNano;
    protected JdbcSqlStat sqlStat;
    protected boolean firstResultSet;
    protected ArrayList<String> batchSqlList;
    protected StatementExecuteType lastExecuteType;
    protected Integer updateCount = null;
    private FilterChainImpl filterChain = null;

    public StatementProxyImpl(ConnectionProxy connection, Statement statement, long id) {
        super(statement, id);
        this.connection = connection;
        this.statement = statement;
    }

    @Override
    public ConnectionProxy getConnectionProxy() {
        return this.connection;
    }

    @Override
    public Statement getRawObject() {
        return this.statement;
    }

    @Override
    public FilterChainImpl createChain() {
        FilterChainImpl chain = this.filterChain;
        if (chain == null) {
            chain = new FilterChainImpl(this.getConnectionProxy().getDirectDataSource());
        } else {
            this.filterChain = null;
        }
        return chain;
    }

    public void recycleFilterChain(FilterChainImpl chain) {
        chain.reset();
        this.filterChain = chain;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        this.createChain().statement_addBatch(this, sql);
        this.batchSqlList.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_cancel(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        FilterChainImpl chain = this.createChain();
        chain.statement_clearBatch(this);
        this.recycleFilterChain(chain);
        this.batchSqlList.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_clearWarnings(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void close() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_close(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        this.firstResultSet = chain.statement_execute(this, sql);
        this.recycleFilterChain(chain);
        return this.firstResultSet;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        this.firstResultSet = chain.statement_execute((StatementProxy)this, sql, autoGeneratedKeys);
        this.recycleFilterChain(chain);
        return this.firstResultSet;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        this.firstResultSet = chain.statement_execute((StatementProxy)this, sql, columnIndexes);
        this.recycleFilterChain(chain);
        return this.firstResultSet;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        this.firstResultSet = chain.statement_execute((StatementProxy)this, sql, columnNames);
        this.recycleFilterChain(chain);
        return this.firstResultSet;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteType = StatementExecuteType.ExecuteBatch;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        int[] updateCounts = chain.statement_executeBatch(this);
        this.recycleFilterChain(chain);
        if (updateCounts != null && updateCounts.length == 1) {
            this.updateCount = updateCounts[0];
        }
        return updateCounts;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.firstResultSet = true;
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteQuery;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        ResultSetProxy resultSet = chain.statement_executeQuery(this, sql);
        this.recycleFilterChain(chain);
        return resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        this.updateCount = chain.statement_executeUpdate(this, sql);
        this.recycleFilterChain(chain);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        this.updateCount = chain.statement_executeUpdate((StatementProxy)this, sql, autoGeneratedKeys);
        this.recycleFilterChain(chain);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        this.updateCount = chain.statement_executeUpdate((StatementProxy)this, sql, columnIndexes);
        this.recycleFilterChain(chain);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        FilterChainImpl chain = this.createChain();
        this.updateCount = chain.statement_executeUpdate((StatementProxy)this, sql, columnNames);
        this.recycleFilterChain(chain);
        return this.updateCount;
    }

    @Override
    public Connection getConnection() throws SQLException {
        FilterChainImpl chain = this.createChain();
        Connection conn = chain.statement_getConnection(this);
        this.recycleFilterChain(chain);
        return conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.statement_getFetchDirection(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getFetchSize() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.statement_getFetchSize(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        FilterChainImpl chain = this.createChain();
        ResultSetProxy value = chain.statement_getGeneratedKeys(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.statement_getMaxFieldSize(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getMaxRows() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.statement_getMaxRows(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.statement_getMoreResults(this);
        if (value) {
            this.updateCount = null;
        }
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.updateCount = null;
        FilterChainImpl chain = this.createChain();
        boolean value = chain.statement_getMoreResults(this, current);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.statement_getQueryTimeout(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        FilterChainImpl chain = this.createChain();
        ResultSetProxy value = chain.statement_getResultSet(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.statement_getResultSetConcurrency(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.statement_getResultSetHoldability(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getResultSetType() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.statement_getResultSetType(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.updateCount == null) {
            FilterChainImpl chain = this.createChain();
            this.updateCount = chain.statement_getUpdateCount(this);
            this.recycleFilterChain(chain);
        }
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        FilterChainImpl chain = this.createChain();
        SQLWarning value = chain.statement_getWarnings(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isClosed() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.statement_isClosed(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.statement_isPoolable(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_setCursorName(this, name);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_setEscapeProcessing(this, enable);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_setFetchDirection(this, direction);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_setFetchSize(this, rows);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_setMaxFieldSize(this, max);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_setMaxRows(this, max);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_setPoolable(this, poolable);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.statement_setQueryTimeout(this, seconds);
        this.recycleFilterChain(chain);
    }

    @Override
    public List<String> getBatchSqlList() {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        return this.batchSqlList;
    }

    @Override
    public String getBatchSql() {
        List<String> sqlList = this.getBatchSqlList();
        StringBuffer buf = new StringBuffer();
        for (String item : sqlList) {
            if (buf.length() > 0) {
                buf.append("\n;\n");
            }
            buf.append(item);
        }
        return buf.toString();
    }

    @Override
    public String getLastExecuteSql() {
        return this.lastExecuteSql;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Map<Integer, JdbcParameter> getParameters() {
        return Collections.emptyMap();
    }

    @Override
    public JdbcSqlStat getSqlStat() {
        return this.sqlStat;
    }

    @Override
    public void setSqlStat(JdbcSqlStat sqlStat) {
        this.sqlStat = sqlStat;
    }

    @Override
    public long getLastExecuteTimeNano() {
        return this.lastExecuteTimeNano;
    }

    @Override
    public void setLastExecuteTimeNano(long lastExecuteTimeNano) {
        this.lastExecuteTimeNano = lastExecuteTimeNano;
    }

    @Override
    public void setLastExecuteTimeNano() {
        if (this.lastExecuteTimeNano <= 0L && this.lastExecuteStartNano > 0L) {
            this.lastExecuteTimeNano = System.nanoTime() - this.lastExecuteStartNano;
        }
    }

    @Override
    public long getLastExecuteStartNano() {
        return this.lastExecuteStartNano;
    }

    @Override
    public void setLastExecuteStartNano(long lastExecuteStartNano) {
        this.lastExecuteStartNano = lastExecuteStartNano;
        this.lastExecuteTimeNano = -1L;
    }

    @Override
    public void setLastExecuteStartNano() {
        if (this.lastExecuteStartNano <= 0L) {
            this.setLastExecuteStartNano(System.nanoTime());
        }
    }

    @Override
    public StatementExecuteType getLastExecuteType() {
        return this.lastExecuteType;
    }

    @Override
    public boolean isFirstResultSet() {
        return this.firstResultSet;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == StatementProxy.class) {
            return (T)this;
        }
        return super.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == StatementProxy.class) {
            return true;
        }
        return super.isWrapperFor(iface);
    }

    @Override
    public int getParametersSize() {
        return 0;
    }

    @Override
    public JdbcParameter getParameter(int i) {
        return null;
    }
}

