/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.producer;

import java.util.List;
import java.util.Random;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;

public class SelectMessageQueueByIsolatedLB
implements MessageQueueSelector {
    private static int defaultLoadBalance = 4;
    private int maxLoadBalance = defaultLoadBalance;
    private Random random = new Random(this.maxLoadBalance);

    public SelectMessageQueueByIsolatedLB() {
    }

    public SelectMessageQueueByIsolatedLB(int maxLB) {
        this.maxLoadBalance = Math.abs(maxLB);
        this.random = new Random(this.maxLoadBalance);
    }

    public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
        int value = arg.hashCode();
        if (value < 0) {
            value = Math.abs(value);
        }
        if (mqs.size() > this.maxLoadBalance) {
            int partitionQueue = mqs.size() / this.maxLoadBalance;
            int randomPartition = this.random.nextInt(this.maxLoadBalance);
            return mqs.get(randomPartition * partitionQueue + (value %= partitionQueue));
        }
        return mqs.get(value % mqs.size());
    }
}

