/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.autoconfigure;

import cn.bizvane.rocketmq.spring.autoconfigure.RocketMQProperties;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerAnnotationBean;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerBean;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerConfigurationBean;
import cn.bizvane.rocketmq.spring.core.consumer.MessageListenerConcurrentlyImpl;
import cn.bizvane.rocketmq.spring.core.consumer.MessageListenerOrderlyImpl;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.bizvane.rocketmq.spring.core.producer.stat.RocketMQSendStats;
import java.util.Optional;
import java.util.function.Function;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.MQAdmin;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={RocketMQProperties.class})
@ConditionalOnClass(value={MQAdmin.class})
@ConditionalOnProperty(prefix="bizvane.rocketmq", value={"name-server"}, matchIfMissing=false)
public class RocketMQAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RocketMQAutoConfiguration.class);
    static final String START = "start";
    static final String SHUTDOWN = "shutdown";

    @Configuration
    @ConditionalOnProperty(prefix="bizvane.rocketmq.consumer", value={"group-name"}, matchIfMissing=false)
    public static class ConsumerConfiguration {
        @Bean(initMethod="start", destroyMethod="shutdown")
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"bizvane.rocketmq.consumer.consume-register-mode"}, havingValue="Configuration")
        public ConsumerBean consumerConfigurationBean(RocketMQProperties rocketMQProperties, ApplicationContext ctx) {
            return new ConsumerConfigurationBean(rocketMQProperties, ctx);
        }

        @Bean(initMethod="start", destroyMethod="shutdown")
        @ConditionalOnMissingBean
        public ConsumerBean consumerAnnotationBean(RocketMQProperties rocketMQProperties, ApplicationContext ctx, MessageListenerOrderly listenerOrderly, MessageListenerConcurrently listenerConcurrently) {
            return new ConsumerAnnotationBean(rocketMQProperties, ctx, listenerOrderly, listenerConcurrently);
        }

        @Bean
        @ConditionalOnMissingBean
        public MessageListenerOrderly messageListenerOrderly(RocketMQProperties rocketMQProperties) {
            return new MessageListenerOrderlyImpl(rocketMQProperties.getConsumer().getRetryStrategy());
        }

        @Bean
        @ConditionalOnMissingBean
        public MessageListenerConcurrently messageListenerConcurrently() {
            return new MessageListenerConcurrentlyImpl();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="bizvane.rocketmq.producer", value={"group-name"}, matchIfMissing=false)
    public static class ProducerConfiguration {
        @Bean(initMethod="start", destroyMethod="shutdown")
        @ConditionalOnMissingBean
        public MQProducer mqProducer(RocketMQProperties rocketMQProperties) {
            RocketMQProperties.Producer pc = rocketMQProperties.getProducer();
            Function<RocketMQProperties, DefaultMQProducer> producerBiFunction = rp -> new DefaultMQProducer(StringUtils.hasText((String)rp.getAccessKey()) && StringUtils.hasText((String)rp.getSecretKey()) ? new AclClientRPCHook(new SessionCredentials(rocketMQProperties.getAccessKey(), rocketMQProperties.getSecretKey())) : null);
            DefaultMQProducer mqProducer = producerBiFunction.apply(rocketMQProperties);
            mqProducer.setNamesrvAddr(rocketMQProperties.getNameServer());
            mqProducer.setProducerGroup(pc.getGroupName());
            if (rocketMQProperties.isNamespaceEnable()) {
                mqProducer.setNamespace(rocketMQProperties.getNamespace().toString());
            }
            Optional.ofNullable(pc).ifPresent(p -> {
                Optional.ofNullable(p.getSendMessageTimeout()).ifPresent(arg_0 -> ((DefaultMQProducer)mqProducer).setSendMsgTimeout(arg_0));
                Optional.ofNullable(p.getCompressMsgBodyOverHowmuch()).ifPresent(arg_0 -> ((DefaultMQProducer)mqProducer).setCompressMsgBodyOverHowmuch(arg_0));
                Optional.ofNullable(p.getRetryTimesWhenSendFailed()).ifPresent(arg_0 -> ((DefaultMQProducer)mqProducer).setRetryTimesWhenSendFailed(arg_0));
                Optional.ofNullable(p.getRetryTimesWhenSendAsyncFailed()).ifPresent(arg_0 -> ((DefaultMQProducer)mqProducer).setRetryTimesWhenSendAsyncFailed(arg_0));
                Optional.ofNullable(p.getRetryAnotherBrokerWhenNotStoreOK()).ifPresent(arg_0 -> ((DefaultMQProducer)mqProducer).setRetryAnotherBrokerWhenNotStoreOK(arg_0));
                Optional.ofNullable(p.getMaxMessageSize()).ifPresent(arg_0 -> ((DefaultMQProducer)mqProducer).setMaxMessageSize(arg_0));
            });
            log.info("Create rocketMq producer finish");
            return mqProducer;
        }

        @Bean
        @ConditionalOnBean(value={MQProducer.class})
        @ConditionalOnMissingBean
        public RocketMQSendStats rocketMQSendStats() {
            return new RocketMQSendStats();
        }

        @Bean
        @ConditionalOnBean(value={MQProducer.class})
        @ConditionalOnMissingBean
        public RocketMQTemplate rocketMQTemplate(MQProducer producer, RocketMQSendStats mqSendStats, RocketMQProperties rocketMQProperties) {
            return new RocketMQTemplate(producer, rocketMQProperties.getProducer(), mqSendStats);
        }
    }
}

