package cn.bizvane.rocketmq.spring.core.producer.stat;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import com.google.common.collect.Maps;

import java.util.Map;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author  wang.zeyan
 * 2019/10/29
 */
public class RocketMQSendStats extends Observable {

    /**
     * 发送统计
     */
    private final Map<Destination, AtomicLong> sendTotalStats = Maps.newConcurrentMap();

    /**
     * 发送成功统计
     */
    private final Map<Destination, AtomicLong> sendSuccessStats = Maps.newConcurrentMap();

    /**
     * 发送失败统计
     */
    private final Map<Destination, AtomicLong> sendFailStats = Maps.newConcurrentMap();

    /**
     * 发送失败重试统计
     */
    private final Map<Destination , AtomicLong> sendFailRetryStats = Maps.newConcurrentMap();

    public void success(Destination destination) {
        increment(destination, sendSuccessStats);
    }

    public void fail(Destination destination) {
        increment(destination, sendFailStats);
    }

    public void failRetry(Destination destination){
        increment(destination, sendFailRetryStats);
    }

    public void total(Destination destination){
        increment(destination, sendTotalStats);
    }

    public long getTotal(Destination destination) {

        AtomicLong r = sendTotalStats.get(destination);
        return r == null ? 0 : r.getAndSet(0);
    }

    public long getSuccess(Destination destination) {

        AtomicLong r = sendSuccessStats.get(destination);
        return r == null ? 0 : r.getAndSet(0);
    }

    public long getFail(Destination destination) {

        AtomicLong r = sendFailStats.get(destination);
        return r == null ? 0 : r.getAndSet(0);
    }

    private void increment(Destination destination, Map<Destination, AtomicLong> stats) {
        AtomicLong atomicLong = stats.get(destination);
        if(atomicLong == null) {
            atomicLong = new AtomicLong();
            stats.put(destination, atomicLong);
            this.setChanged();
            this.notifyObservers(destination);
        }
        atomicLong.incrementAndGet();
    }
}
