package cn.bizvane.rocketmq.spring.core.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.util.IOUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.BeanUtils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

/**
 * @author wang.zeyan
 * @date 2019/08/22
 */
public class RocketMQConsumerUtils {

    public static RocketMQListener getListener(String topic, String tags) {

        if(ConsumerBean.SUBSCRIPTION_TABLE == null) {
            return null;
        }

        if(ConsumerBean.SUBSCRIPTION_TABLE.get(topic) == null) {
            return null;
        }

        RocketMQListener rocketMQListener = ConsumerBean.SUBSCRIPTION_TABLE.get(topic).get(tags);

        return rocketMQListener != null ? rocketMQListener : ConsumerBean.SUBSCRIPTION_TABLE.get(topic).get("*");
    }

    public static ConsumerMessage convertMessage(MessageExt messageExt, RocketMQListener listener){
        Type bodyType = null;
        Type[] genericInterfaces = listener.getClass().getGenericInterfaces();
        for (Type type : genericInterfaces) {
            if(type instanceof ParameterizedType && type.getTypeName().startsWith(RocketMQListener.class.getName())) {
                bodyType = ((ParameterizedType) type).getActualTypeArguments()[0];
            }
        }
        ConsumerMessage message = new ConsumerMessage();
        BeanUtils.copyProperties(messageExt, message);

        String body = new String(messageExt.getBody(), IOUtils.UTF8);
        if(Objects.equals(body.getClass(), bodyType)) {
            message.setMessage(body);
        }else{
            message.setMessage(JSON.parseObject(body, bodyType));
        }
        return message;
    }
}
