package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.exception.ConsumerListenerFindException;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;
import java.util.Optional;

/**
 * @author wang.zeyan
 * @date 2019/08/20
 */
@Slf4j
public class MessageListenerOrderlyImpl extends AbstractMessageListener implements MessageListenerOrderly {

    private RetryStrategy retryStrategy = RetryStrategy.RETRY_UNTIL_SUCCESS;

    public MessageListenerOrderlyImpl(RetryStrategy retryStrategy) {
        if(retryStrategy != null) {
            this.retryStrategy = retryStrategy;
        }
    }

    @Override
    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        final MessageExt messageExt = msgs.get(0);
        try {
            abstractConsumer.accept(messageExt);
            return ConsumeOrderlyStatus.SUCCESS;
        } catch (ConsumerListenerFindException e) {
            log.error("消费异常", e);
            return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
        } catch (Exception e) {
            log.error("消费异常", e);
            if(retryStrategy == RetryStrategy.RETRY_UNTIL_SUCCESS) {
                // 关闭自动提交
                context.setAutoCommit(false);
                // 设置重试为 未成功一直重试, 直到成功位置。 成功后继续消费当前队列消息
                messageExt.setReconsumeTimes(-1);
            }
            return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
        } finally {
            //Optional.ofNullable(messageExt).ifPresent(messageDiff);
        }
    }


}
